/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.reactor.AbstractIODispatch;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpServerEventHandler;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpServerIODispatch
extends AbstractIODispatch<DefaultNHttpServerConnection> {
    private final NHttpServerEventHandler handler;
    private final NHttpConnectionFactory<? extends DefaultNHttpServerConnection> connFactory;

    public DefaultHttpServerIODispatch(NHttpServerEventHandler nHttpServerEventHandler, NHttpConnectionFactory<? extends DefaultNHttpServerConnection> nHttpConnectionFactory) {
        this.handler = Args.notNull(nHttpServerEventHandler, "HTTP client handler");
        this.connFactory = Args.notNull(nHttpConnectionFactory, "HTTP server connection factory");
    }

    @Deprecated
    public DefaultHttpServerIODispatch(NHttpServerEventHandler nHttpServerEventHandler, HttpParams httpParams) {
        this(nHttpServerEventHandler, new DefaultNHttpServerConnectionFactory(httpParams));
    }

    @Deprecated
    public DefaultHttpServerIODispatch(NHttpServerEventHandler nHttpServerEventHandler, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpParams httpParams) {
        this(nHttpServerEventHandler, new SSLNHttpServerConnectionFactory(sSLContext, sSLSetupHandler, httpParams));
    }

    @Deprecated
    public DefaultHttpServerIODispatch(NHttpServerEventHandler nHttpServerEventHandler, SSLContext sSLContext, HttpParams httpParams) {
        this(nHttpServerEventHandler, sSLContext, null, httpParams);
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler nHttpServerEventHandler, ConnectionConfig connectionConfig) {
        this(nHttpServerEventHandler, new DefaultNHttpServerConnectionFactory(connectionConfig));
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler nHttpServerEventHandler, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, ConnectionConfig connectionConfig) {
        this(nHttpServerEventHandler, new SSLNHttpServerConnectionFactory(sSLContext, sSLSetupHandler, connectionConfig));
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler nHttpServerEventHandler, SSLContext sSLContext, ConnectionConfig connectionConfig) {
        this(nHttpServerEventHandler, new SSLNHttpServerConnectionFactory(sSLContext, null, connectionConfig));
    }

    @Override
    protected DefaultNHttpServerConnection createConnection(IOSession iOSession) {
        return this.connFactory.createConnection(iOSession);
    }

    @Override
    protected void onConnected(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        try {
            this.handler.connected(defaultNHttpServerConnection);
        }
        catch (Exception exception) {
            this.handler.exception(defaultNHttpServerConnection, exception);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        this.handler.closed(defaultNHttpServerConnection);
    }

    @Override
    protected void onException(DefaultNHttpServerConnection defaultNHttpServerConnection, IOException iOException) {
        this.handler.exception(defaultNHttpServerConnection, iOException);
    }

    @Override
    protected void onInputReady(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        defaultNHttpServerConnection.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        defaultNHttpServerConnection.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpServerConnection defaultNHttpServerConnection) {
        try {
            this.handler.timeout(defaultNHttpServerConnection);
        }
        catch (Exception exception) {
            this.handler.exception(defaultNHttpServerConnection, exception);
        }
    }
}

