/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.ConnSupport;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    public static final DefaultNHttpClientConnectionFactory INSTANCE = new DefaultNHttpClientConnectionFactory();
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public DefaultNHttpClientConnectionFactory(HttpResponseFactory httpResponseFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        Args.notNull(httpResponseFactory, "HTTP response factory");
        Args.notNull(byteBufferAllocator, "Byte buffer allocator");
        Args.notNull(httpParams, "HTTP parameters");
        this.allocator = byteBufferAllocator;
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.responseParserFactory = new DefaultHttpResponseParserFactory(null, httpResponseFactory);
        this.requestWriterFactory = null;
        this.cconfig = HttpParamConfig.getConnectionConfig(httpParams);
    }

    @Deprecated
    public DefaultNHttpClientConnectionFactory(HttpParams httpParams) {
        this(DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    public DefaultNHttpClientConnectionFactory(ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this.incomingContentStrategy = contentLengthStrategy;
        this.outgoingContentStrategy = contentLengthStrategy2;
        this.responseParserFactory = nHttpMessageParserFactory;
        this.requestWriterFactory = nHttpMessageWriterFactory;
        this.allocator = byteBufferAllocator;
        this.cconfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpClientConnectionFactory(NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this(null, null, nHttpMessageParserFactory, nHttpMessageWriterFactory, byteBufferAllocator, connectionConfig);
    }

    public DefaultNHttpClientConnectionFactory(NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, ConnectionConfig connectionConfig) {
        this(null, null, nHttpMessageParserFactory, nHttpMessageWriterFactory, null, connectionConfig);
    }

    public DefaultNHttpClientConnectionFactory(ConnectionConfig connectionConfig) {
        this(null, null, null, null, null, connectionConfig);
    }

    public DefaultNHttpClientConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Deprecated
    protected DefaultNHttpClientConnection createConnection(IOSession iOSession, HttpResponseFactory httpResponseFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        return new DefaultNHttpClientConnection(iOSession, httpResponseFactory, byteBufferAllocator, httpParams);
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession iOSession) {
        return new DefaultNHttpClientConnection(iOSession, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
    }
}

