/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.Consts;
import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpConnectionMetrics;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpInetConnection;
import com.icbc.api.internal.apache.http.HttpMessage;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.entity.BasicHttpEntity;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.HttpConnectionMetricsImpl;
import com.icbc.api.internal.apache.http.impl.entity.LaxContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.entity.StrictContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.impl.nio.SessionHttpContext;
import com.icbc.api.internal.apache.http.impl.nio.codecs.ChunkDecoder;
import com.icbc.api.internal.apache.http.impl.nio.codecs.ChunkEncoder;
import com.icbc.api.internal.apache.http.impl.nio.codecs.IdentityDecoder;
import com.icbc.api.internal.apache.http.impl.nio.codecs.IdentityEncoder;
import com.icbc.api.internal.apache.http.impl.nio.codecs.LengthDelimitedDecoder;
import com.icbc.api.internal.apache.http.impl.nio.codecs.LengthDelimitedEncoder;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SessionInputBufferImpl;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SessionOutputBufferImpl;
import com.icbc.api.internal.apache.http.io.HttpTransportMetrics;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.NHttpConnection;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionBufferStatus;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.SocketAccessor;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharsetUtils;
import com.icbc.api.internal.apache.http.util.NetUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class NHttpConnectionBase
implements HttpInetConnection,
NHttpConnection,
SessionBufferStatus,
SocketAccessor {
    protected final ContentLengthStrategy incomingContentStrategy;
    protected final ContentLengthStrategy outgoingContentStrategy;
    protected final SessionInputBufferImpl inbuf;
    protected final SessionOutputBufferImpl outbuf;
    private final int fragmentSizeHint;
    private final MessageConstraints constraints;
    protected final HttpTransportMetricsImpl inTransportMetrics;
    protected final HttpTransportMetricsImpl outTransportMetrics;
    protected final HttpConnectionMetricsImpl connMetrics;
    protected HttpContext context;
    protected IOSession session;
    protected SocketAddress remote;
    protected volatile ContentDecoder contentDecoder;
    protected volatile boolean hasBufferedInput;
    protected volatile ContentEncoder contentEncoder;
    protected volatile boolean hasBufferedOutput;
    protected volatile HttpRequest request;
    protected volatile HttpResponse response;
    protected volatile int status;

    @Deprecated
    public NHttpConnectionBase(IOSession iOSession, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        int n;
        Args.notNull(iOSession, "I/O session");
        Args.notNull(httpParams, "HTTP params");
        int n2 = httpParams.getIntParameter("http.socket.buffer-size", -1);
        if (n2 <= 0) {
            n2 = 4096;
        }
        if ((n = n2) > 512) {
            n = 512;
        }
        CharsetDecoder charsetDecoder = null;
        CharsetEncoder charsetEncoder = null;
        Charset charset = CharsetUtils.lookup((String)httpParams.getParameter("http.protocol.element-charset"));
        if (charset != null) {
            charset = Consts.ASCII;
            charsetDecoder = charset.newDecoder();
            charsetEncoder = charset.newEncoder();
            CodingErrorAction codingErrorAction = (CodingErrorAction)httpParams.getParameter("http.malformed.input.action");
            CodingErrorAction codingErrorAction2 = (CodingErrorAction)httpParams.getParameter("http.unmappable.input.action");
            charsetDecoder.onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction2);
            charsetEncoder.onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction2);
        }
        this.inbuf = new SessionInputBufferImpl(n2, n, charsetDecoder, byteBufferAllocator);
        this.outbuf = new SessionOutputBufferImpl(n2, n, charsetEncoder, byteBufferAllocator);
        this.fragmentSizeHint = n2;
        this.constraints = MessageConstraints.DEFAULT;
        this.incomingContentStrategy = this.createIncomingContentStrategy();
        this.outgoingContentStrategy = this.createOutgoingContentStrategy();
        this.inTransportMetrics = this.createTransportMetrics();
        this.outTransportMetrics = this.createTransportMetrics();
        this.connMetrics = this.createConnectionMetrics(this.inTransportMetrics, this.outTransportMetrics);
        this.setSession(iOSession);
        this.status = 0;
    }

    protected NHttpConnectionBase(IOSession iOSession, int n, int n2, ByteBufferAllocator byteBufferAllocator, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2) {
        Args.notNull(iOSession, "I/O session");
        Args.positive(n, "Buffer size");
        int n3 = n;
        if (n3 > 512) {
            n3 = 512;
        }
        this.inbuf = new SessionInputBufferImpl(n, n3, charsetDecoder, byteBufferAllocator);
        this.outbuf = new SessionOutputBufferImpl(n, n3, charsetEncoder, byteBufferAllocator);
        this.fragmentSizeHint = n2 >= 0 ? n2 : n;
        this.inTransportMetrics = new HttpTransportMetricsImpl();
        this.outTransportMetrics = new HttpTransportMetricsImpl();
        this.connMetrics = new HttpConnectionMetricsImpl(this.inTransportMetrics, this.outTransportMetrics);
        this.constraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.incomingContentStrategy = contentLengthStrategy != null ? contentLengthStrategy : LaxContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = contentLengthStrategy2 != null ? contentLengthStrategy2 : StrictContentLengthStrategy.INSTANCE;
        this.setSession(iOSession);
        this.status = 0;
    }

    protected NHttpConnectionBase(IOSession iOSession, int n, int n2, ByteBufferAllocator byteBufferAllocator, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2) {
        this(iOSession, n, n2, byteBufferAllocator, charsetDecoder, charsetEncoder, null, contentLengthStrategy, contentLengthStrategy2);
    }

    private void setSession(IOSession iOSession) {
        this.session = iOSession;
        this.context = new SessionHttpContext(this.session);
        this.session.setBufferStatus(this);
        this.remote = this.session.getRemoteAddress();
    }

    protected void bind(IOSession iOSession) {
        Args.notNull(iOSession, "I/O session");
        this.setSession(iOSession);
    }

    @Deprecated
    protected ContentLengthStrategy createIncomingContentStrategy() {
        return new LaxContentLengthStrategy();
    }

    @Deprecated
    protected ContentLengthStrategy createOutgoingContentStrategy() {
        return new StrictContentLengthStrategy();
    }

    @Deprecated
    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    @Deprecated
    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics httpTransportMetrics, HttpTransportMetrics httpTransportMetrics2) {
        return new HttpConnectionMetricsImpl(httpTransportMetrics, httpTransportMetrics2);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public HttpRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public void requestInput() {
        this.session.setEvent(1);
    }

    @Override
    public void requestOutput() {
        this.session.setEvent(4);
    }

    @Override
    public void suspendInput() {
        this.session.clearEvent(1);
    }

    @Override
    public void suspendOutput() {
        this.session.clearEvent(4);
    }

    protected HttpEntity prepareDecoder(HttpMessage httpMessage) throws HttpException {
        Header header;
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        long l = this.incomingContentStrategy.determineLength(httpMessage);
        this.contentDecoder = this.createContentDecoder(l, this.session.channel(), this.inbuf, this.inTransportMetrics);
        if (l == -2L) {
            basicHttpEntity.setChunked(true);
            basicHttpEntity.setContentLength(-1L);
        } else if (l == -1L) {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(-1L);
        } else {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(l);
        }
        Header header2 = httpMessage.getFirstHeader("Content-Type");
        if (header2 != null) {
            basicHttpEntity.setContentType(header2);
        }
        if ((header = httpMessage.getFirstHeader("Content-Encoding")) != null) {
            basicHttpEntity.setContentEncoding(header);
        }
        return basicHttpEntity;
    }

    protected ContentDecoder createContentDecoder(long l, ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        if (l == -2L) {
            return new ChunkDecoder(readableByteChannel, sessionInputBuffer, this.constraints, httpTransportMetricsImpl);
        }
        if (l == -1L) {
            return new IdentityDecoder(readableByteChannel, sessionInputBuffer, httpTransportMetricsImpl);
        }
        return new LengthDelimitedDecoder(readableByteChannel, sessionInputBuffer, httpTransportMetricsImpl, l);
    }

    protected void prepareEncoder(HttpMessage httpMessage) throws HttpException {
        long l = this.outgoingContentStrategy.determineLength(httpMessage);
        this.contentEncoder = this.createContentEncoder(l, this.session.channel(), this.outbuf, this.outTransportMetrics);
    }

    protected ContentEncoder createContentEncoder(long l, WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        if (l == -2L) {
            return new ChunkEncoder(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl, this.fragmentSizeHint);
        }
        if (l == -1L) {
            return new IdentityEncoder(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl, this.fragmentSizeHint);
        }
        return new LengthDelimitedEncoder(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl, l, this.fragmentSizeHint);
    }

    @Override
    public boolean hasBufferedInput() {
        return this.hasBufferedInput;
    }

    @Override
    public boolean hasBufferedOutput() {
        return this.hasBufferedOutput;
    }

    protected void assertNotClosed() throws ConnectionClosedException {
        if (this.status != 0) {
            throw new ConnectionClosedException("Connection is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.status != 0) {
            return;
        }
        this.status = 1;
        if (this.outbuf.hasData()) {
            this.session.setEvent(4);
        } else {
            this.session.close();
            this.status = 2;
        }
    }

    @Override
    public boolean isOpen() {
        return this.status == 0 && !this.session.isClosed();
    }

    @Override
    public boolean isStale() {
        return this.session.isClosed();
    }

    @Override
    public InetAddress getLocalAddress() {
        SocketAddress socketAddress = this.session.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getAddress();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        SocketAddress socketAddress = this.session.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getPort();
        }
        return -1;
    }

    @Override
    public InetAddress getRemoteAddress() {
        SocketAddress socketAddress = this.session.getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getAddress();
        }
        return null;
    }

    @Override
    public int getRemotePort() {
        SocketAddress socketAddress = this.session.getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getPort();
        }
        return -1;
    }

    @Override
    public void setSocketTimeout(int n) {
        this.session.setSocketTimeout(n);
    }

    @Override
    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    @Override
    public void shutdown() throws IOException {
        this.status = 2;
        this.session.shutdown();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.connMetrics;
    }

    public String toString() {
        SocketAddress socketAddress = this.session.getRemoteAddress();
        SocketAddress socketAddress2 = this.session.getLocalAddress();
        if (socketAddress != null && socketAddress2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            NetUtils.formatAddress(stringBuilder, socketAddress2);
            stringBuilder.append("<->");
            NetUtils.formatAddress(stringBuilder, socketAddress);
            return stringBuilder.toString();
        }
        return "[Not bound]";
    }

    @Override
    public Socket getSocket() {
        if (this.session instanceof SocketAccessor) {
            return ((SocketAccessor)((Object)this.session)).getSocket();
        }
        return null;
    }
}

