/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SSLIOSession;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SSLMode;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.NHttpClientHandler;
import com.icbc.api.internal.apache.http.nio.NHttpClientIOTarget;
import com.icbc.api.internal.apache.http.nio.reactor.IOEventDispatch;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

@Deprecated
public class SSLClientIOEventDispatch
implements IOEventDispatch {
    private static final String SSL_SESSION = "SSL_SESSION";
    protected final NHttpClientHandler handler;
    protected final SSLContext sslcontext;
    protected final SSLIOSessionHandler sslHandler;
    protected final HttpParams params;

    public SSLClientIOEventDispatch(NHttpClientHandler nHttpClientHandler, SSLContext sSLContext, SSLIOSessionHandler sSLIOSessionHandler, HttpParams httpParams) {
        Args.notNull(nHttpClientHandler, "HTTP client handler");
        Args.notNull(sSLContext, "SSL context");
        Args.notNull(httpParams, "HTTP parameters");
        this.handler = nHttpClientHandler;
        this.params = httpParams;
        this.sslcontext = sSLContext;
        this.sslHandler = sSLIOSessionHandler;
    }

    public SSLClientIOEventDispatch(NHttpClientHandler nHttpClientHandler, SSLContext sSLContext, HttpParams httpParams) {
        this(nHttpClientHandler, sSLContext, null, httpParams);
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return HeapByteBufferAllocator.INSTANCE;
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return DefaultHttpResponseFactory.INSTANCE;
    }

    protected NHttpClientIOTarget createConnection(IOSession iOSession) {
        return new DefaultNHttpClientConnection(iOSession, this.createHttpResponseFactory(), this.createByteBufferAllocator(), this.params);
    }

    protected SSLIOSession createSSLIOSession(IOSession iOSession, SSLContext sSLContext, SSLIOSessionHandler sSLIOSessionHandler) {
        return new SSLIOSession(iOSession, sSLContext, sSLIOSessionHandler);
    }

    @Override
    public void connected(IOSession iOSession) {
        SSLIOSession sSLIOSession = this.createSSLIOSession(iOSession, this.sslcontext, this.sslHandler);
        NHttpClientIOTarget nHttpClientIOTarget = this.createConnection(sSLIOSession);
        iOSession.setAttribute("http.connection", nHttpClientIOTarget);
        iOSession.setAttribute(SSL_SESSION, sSLIOSession);
        Object object = iOSession.getAttribute("http.session.attachment");
        this.handler.connected(nHttpClientIOTarget, object);
        try {
            sSLIOSession.bind(SSLMode.CLIENT, this.params);
        }
        catch (SSLException sSLException) {
            this.handler.exception((NHttpClientConnection)nHttpClientIOTarget, sSLException);
            sSLIOSession.shutdown();
        }
    }

    @Override
    public void disconnected(IOSession iOSession) {
        NHttpClientIOTarget nHttpClientIOTarget = (NHttpClientIOTarget)iOSession.getAttribute("http.connection");
        if (nHttpClientIOTarget != null) {
            this.handler.closed(nHttpClientIOTarget);
        }
    }

    @Override
    public void inputReady(IOSession iOSession) {
        NHttpClientIOTarget nHttpClientIOTarget = (NHttpClientIOTarget)iOSession.getAttribute("http.connection");
        SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute(SSL_SESSION);
        try {
            if (sSLIOSession.isAppInputReady()) {
                nHttpClientIOTarget.consumeInput(this.handler);
            }
            sSLIOSession.inboundTransport();
        }
        catch (IOException iOException) {
            this.handler.exception((NHttpClientConnection)nHttpClientIOTarget, iOException);
            sSLIOSession.shutdown();
        }
    }

    @Override
    public void outputReady(IOSession iOSession) {
        NHttpClientIOTarget nHttpClientIOTarget = (NHttpClientIOTarget)iOSession.getAttribute("http.connection");
        SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute(SSL_SESSION);
        try {
            if (sSLIOSession.isAppOutputReady()) {
                nHttpClientIOTarget.produceOutput(this.handler);
            }
            sSLIOSession.outboundTransport();
        }
        catch (IOException iOException) {
            this.handler.exception((NHttpClientConnection)nHttpClientIOTarget, iOException);
            sSLIOSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeout(IOSession iOSession) {
        NHttpClientIOTarget nHttpClientIOTarget = (NHttpClientIOTarget)iOSession.getAttribute("http.connection");
        SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute(SSL_SESSION);
        this.handler.timeout(nHttpClientIOTarget);
        SSLIOSession sSLIOSession2 = sSLIOSession;
        synchronized (sSLIOSession2) {
            if (sSLIOSession.isOutboundDone() && !sSLIOSession.isInboundDone()) {
                sSLIOSession.shutdown();
            }
        }
    }
}

