/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestFactory;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.ConnSupport;
import com.icbc.api.internal.apache.http.impl.DefaultHttpRequestFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLIOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLMode;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.ssl.SSLContexts;
import com.icbc.api.internal.apache.http.util.Args;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class SSLNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public SSLNHttpServerConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpRequestFactory httpRequestFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        Args.notNull(httpRequestFactory, "HTTP request factory");
        Args.notNull(byteBufferAllocator, "Byte buffer allocator");
        Args.notNull(httpParams, "HTTP parameters");
        this.sslcontext = sSLContext != null ? sSLContext : SSLContexts.createSystemDefault();
        this.sslHandler = sSLSetupHandler;
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, httpRequestFactory);
        this.responseWriterFactory = null;
        this.allocator = byteBufferAllocator;
        this.cconfig = HttpParamConfig.getConnectionConfig(httpParams);
    }

    @Deprecated
    public SSLNHttpServerConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpParams httpParams) {
        this(sSLContext, sSLSetupHandler, DefaultHttpRequestFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    @Deprecated
    public SSLNHttpServerConnectionFactory(HttpParams httpParams) {
        this(null, null, httpParams);
    }

    public SSLNHttpServerConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, NHttpMessageParserFactory<HttpRequest> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpResponse> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this.sslcontext = sSLContext != null ? sSLContext : SSLContexts.createSystemDefault();
        this.sslHandler = sSLSetupHandler;
        this.incomingContentStrategy = contentLengthStrategy;
        this.outgoingContentStrategy = contentLengthStrategy2;
        this.requestParserFactory = nHttpMessageParserFactory;
        this.responseWriterFactory = nHttpMessageWriterFactory;
        this.allocator = byteBufferAllocator;
        this.cconfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    public SSLNHttpServerConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, NHttpMessageParserFactory<HttpRequest> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpResponse> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this(sSLContext, sSLSetupHandler, null, null, nHttpMessageParserFactory, nHttpMessageWriterFactory, byteBufferAllocator, connectionConfig);
    }

    public SSLNHttpServerConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, NHttpMessageParserFactory<HttpRequest> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpResponse> nHttpMessageWriterFactory, ConnectionConfig connectionConfig) {
        this(sSLContext, sSLSetupHandler, null, null, nHttpMessageParserFactory, nHttpMessageWriterFactory, null, connectionConfig);
    }

    public SSLNHttpServerConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, ConnectionConfig connectionConfig) {
        this(sSLContext, sSLSetupHandler, null, null, null, null, null, connectionConfig);
    }

    public SSLNHttpServerConnectionFactory(ConnectionConfig connectionConfig) {
        this(null, null, null, null, null, null, null, connectionConfig);
    }

    public SSLNHttpServerConnectionFactory() {
        this(null, null, null, null, null, null, null, null);
    }

    @Deprecated
    protected DefaultNHttpServerConnection createConnection(IOSession iOSession, HttpRequestFactory httpRequestFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        return new DefaultNHttpServerConnection(iOSession, httpRequestFactory, byteBufferAllocator, httpParams);
    }

    protected SSLIOSession createSSLIOSession(IOSession iOSession, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler) {
        SSLIOSession sSLIOSession = new SSLIOSession(iOSession, SSLMode.SERVER, sSLContext, sSLSetupHandler);
        return sSLIOSession;
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession iOSession) {
        SSLIOSession sSLIOSession = this.createSSLIOSession(iOSession, this.sslcontext, this.sslHandler);
        iOSession.setAttribute("http.session.ssl", sSLIOSession);
        return new DefaultNHttpServerConnection(sSLIOSession, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestParserFactory, this.responseWriterFactory);
    }
}

