/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.bootstrap;

import com.icbc.api.internal.apache.http.ExceptionLogger;
import com.icbc.api.internal.apache.http.impl.nio.DefaultHttpServerIODispatch;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.icbc.api.internal.apache.http.impl.nio.bootstrap.ThreadFactoryImpl;
import com.icbc.api.internal.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpServerEventHandler;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorExceptionHandler;
import com.icbc.api.internal.apache.http.nio.reactor.ListenerEndpoint;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class HttpServer {
    private final int port;
    private final InetAddress ifAddress;
    private final IOReactorConfig ioReactorConfig;
    private final NHttpServerEventHandler serverEventHandler;
    private final NHttpConnectionFactory<? extends DefaultNHttpServerConnection> connectionFactory;
    private final ExceptionLogger exceptionLogger;
    private final ExecutorService listenerExecutorService;
    private final ThreadGroup dispatchThreads;
    private final AtomicReference<Status> status;
    private final DefaultListeningIOReactor ioReactor;
    private volatile ListenerEndpoint endpoint;

    HttpServer(int n, InetAddress inetAddress, IOReactorConfig iOReactorConfig, NHttpServerEventHandler nHttpServerEventHandler, NHttpConnectionFactory<? extends DefaultNHttpServerConnection> nHttpConnectionFactory, final ExceptionLogger exceptionLogger) {
        this.port = n;
        this.ifAddress = inetAddress;
        this.ioReactorConfig = iOReactorConfig;
        this.serverEventHandler = nHttpServerEventHandler;
        this.connectionFactory = nHttpConnectionFactory;
        this.exceptionLogger = exceptionLogger;
        this.listenerExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryImpl("HTTP-listener-" + this.port));
        this.dispatchThreads = new ThreadGroup("I/O-dispatchers");
        try {
            this.ioReactor = new DefaultListeningIOReactor(this.ioReactorConfig, new ThreadFactoryImpl("I/O-dispatch", this.dispatchThreads));
        }
        catch (IOReactorException iOReactorException) {
            throw new IllegalStateException(iOReactorException);
        }
        this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

            @Override
            public boolean handle(IOException iOException) {
                exceptionLogger.log(iOException);
                return false;
            }

            @Override
            public boolean handle(RuntimeException runtimeException) {
                exceptionLogger.log(runtimeException);
                return false;
            }
        });
        this.status = new AtomicReference<Status>(Status.READY);
    }

    public ListenerEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void start() throws IOException {
        if (this.status.compareAndSet(Status.READY, Status.ACTIVE)) {
            this.endpoint = this.ioReactor.listen(new InetSocketAddress(this.ifAddress, this.port > 0 ? this.port : 0));
            final DefaultHttpServerIODispatch defaultHttpServerIODispatch = new DefaultHttpServerIODispatch(this.serverEventHandler, this.connectionFactory);
            this.listenerExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpServer.this.ioReactor.execute(defaultHttpServerIODispatch);
                    }
                    catch (Exception exception) {
                        HttpServer.this.exceptionLogger.log(exception);
                    }
                }
            });
        }
    }

    public void awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        this.listenerExecutorService.awaitTermination(l, timeUnit);
    }

    public void shutdown(long l, TimeUnit timeUnit) {
        if (this.status.compareAndSet(Status.ACTIVE, Status.STOPPING)) {
            try {
                this.ioReactor.shutdown(timeUnit.toMillis(l));
            }
            catch (IOException iOException) {
                this.exceptionLogger.log(iOException);
            }
            this.listenerExecutorService.shutdown();
        }
    }

    static enum Status {
        READY,
        ACTIVE,
        STOPPING;

    }
}

