/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.methods.HttpRequestWrapper;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.RouteTracker;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;

abstract class AbstractClientExchangeHandler<T>
implements HttpAsyncClientExchangeHandler {
    private static final AtomicLong COUNTER = new AtomicLong(1L);
    protected final Log log;
    private final long id;
    private final HttpClientContext localContext;
    private final BasicFuture<T> resultFuture;
    private final NHttpClientConnectionManager connmgr;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;
    private final AtomicReference<NHttpClientConnection> managedConnRef;
    private final AtomicReference<HttpRoute> routeRef;
    private final AtomicReference<RouteTracker> routeTrackerRef;
    private final AtomicBoolean routeEstablished;
    private final AtomicReference<Long> validDurationRef;
    private final AtomicReference<HttpRequestWrapper> requestRef;
    private final AtomicReference<HttpResponse> responseRef;
    private final AtomicBoolean completed;
    private final AtomicBoolean closed;

    AbstractClientExchangeHandler(Log log, HttpClientContext httpClientContext, BasicFuture<T> basicFuture, NHttpClientConnectionManager nHttpClientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.log = log;
        this.id = COUNTER.getAndIncrement();
        this.localContext = httpClientContext;
        this.resultFuture = basicFuture;
        this.connmgr = nHttpClientConnectionManager;
        this.connReuseStrategy = connectionReuseStrategy;
        this.keepaliveStrategy = connectionKeepAliveStrategy;
        this.managedConnRef = new AtomicReference<Object>(null);
        this.routeRef = new AtomicReference<Object>(null);
        this.routeTrackerRef = new AtomicReference<Object>(null);
        this.routeEstablished = new AtomicBoolean(false);
        this.validDurationRef = new AtomicReference<Object>(null);
        this.requestRef = new AtomicReference<Object>(null);
        this.responseRef = new AtomicReference<Object>(null);
        this.completed = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    final long getId() {
        return this.id;
    }

    final boolean isCompleted() {
        return this.completed.get();
    }

    final void markCompleted() {
        this.completed.set(true);
    }

    final void markConnectionNonReusable() {
        this.validDurationRef.set(null);
    }

    final boolean isRouteEstablished() {
        return this.routeEstablished.get();
    }

    final HttpRoute getRoute() {
        return this.routeRef.get();
    }

    final void setRoute(HttpRoute httpRoute) {
        this.routeRef.set(httpRoute);
    }

    final HttpRequestWrapper getCurrentRequest() {
        return this.requestRef.get();
    }

    final void setCurrentRequest(HttpRequestWrapper httpRequestWrapper) {
        this.requestRef.set(httpRequestWrapper);
    }

    final HttpResponse getCurrentResponse() {
        return this.responseRef.get();
    }

    final void setCurrentResponse(HttpResponse httpResponse) {
        this.responseRef.set(httpResponse);
    }

    final HttpRoute getActualRoute() {
        RouteTracker routeTracker = this.routeTrackerRef.get();
        return routeTracker != null ? routeTracker.toRoute() : null;
    }

    final void verifytRoute() {
        if (!this.routeEstablished.get() && this.routeTrackerRef.get() == null) {
            NHttpClientConnection nHttpClientConnection = this.managedConnRef.get();
            Asserts.check(nHttpClientConnection != null, "Inconsistent state: managed connection is null");
            boolean bl = this.connmgr.isRouteComplete(nHttpClientConnection);
            this.routeEstablished.set(bl);
            if (!bl) {
                this.log.debug((Object)"Start connection routing");
                HttpRoute httpRoute = this.routeRef.get();
                this.routeTrackerRef.set(new RouteTracker(httpRoute));
            } else {
                this.log.debug((Object)"Connection route already established");
            }
        }
    }

    final void onRouteToTarget() throws IOException {
        NHttpClientConnection nHttpClientConnection = this.managedConnRef.get();
        Asserts.check(nHttpClientConnection != null, "Inconsistent state: managed connection is null");
        HttpRoute httpRoute = this.routeRef.get();
        Asserts.check(httpRoute != null, "Inconsistent state: HTTP route is null");
        RouteTracker routeTracker = this.routeTrackerRef.get();
        Asserts.check(routeTracker != null, "Inconsistent state: HTTP route tracker");
        this.connmgr.startRoute(nHttpClientConnection, httpRoute, this.localContext);
        routeTracker.connectTarget(httpRoute.isSecure());
    }

    final void onRouteToProxy() throws IOException {
        NHttpClientConnection nHttpClientConnection = this.managedConnRef.get();
        Asserts.check(nHttpClientConnection != null, "Inconsistent state: managed connection is null");
        HttpRoute httpRoute = this.routeRef.get();
        Asserts.check(httpRoute != null, "Inconsistent state: HTTP route is null");
        RouteTracker routeTracker = this.routeTrackerRef.get();
        Asserts.check(routeTracker != null, "Inconsistent state: HTTP route tracker");
        this.connmgr.startRoute(nHttpClientConnection, httpRoute, this.localContext);
        HttpHost httpHost = httpRoute.getProxyHost();
        routeTracker.connectProxy(httpHost, false);
    }

    final void onRouteUpgrade() throws IOException {
        NHttpClientConnection nHttpClientConnection = this.managedConnRef.get();
        Asserts.check(nHttpClientConnection != null, "Inconsistent state: managed connection is null");
        HttpRoute httpRoute = this.routeRef.get();
        Asserts.check(httpRoute != null, "Inconsistent state: HTTP route is null");
        RouteTracker routeTracker = this.routeTrackerRef.get();
        Asserts.check(routeTracker != null, "Inconsistent state: HTTP route tracker");
        this.connmgr.upgrade(nHttpClientConnection, httpRoute, this.localContext);
        routeTracker.layerProtocol(httpRoute.isSecure());
    }

    final void onRouteTunnelToTarget() {
        RouteTracker routeTracker = this.routeTrackerRef.get();
        Asserts.check(routeTracker != null, "Inconsistent state: HTTP route tracker");
        routeTracker.tunnelTarget(false);
    }

    final void onRouteComplete() {
        NHttpClientConnection nHttpClientConnection = this.managedConnRef.get();
        Asserts.check(nHttpClientConnection != null, "Inconsistent state: managed connection is null");
        HttpRoute httpRoute = this.routeRef.get();
        Asserts.check(httpRoute != null, "Inconsistent state: HTTP route is null");
        this.connmgr.routeComplete(nHttpClientConnection, httpRoute, this.localContext);
        this.routeEstablished.set(true);
        this.routeTrackerRef.set(null);
    }

    final NHttpClientConnection getConnection() {
        return this.managedConnRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void releaseConnection() {
        NHttpClientConnection nHttpClientConnection = this.managedConnRef.getAndSet(null);
        if (nHttpClientConnection != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] releasing connection"));
            }
            nHttpClientConnection.getContext().removeAttribute("http.nio.exchange-handler");
            Long l = this.validDurationRef.get();
            if (l != null) {
                Object object = this.localContext.getUserToken();
                this.connmgr.releaseConnection(nHttpClientConnection, object, l, TimeUnit.MILLISECONDS);
            } else {
                try {
                    nHttpClientConnection.close();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("[exchange: " + this.id + "] connection discarded"));
                    }
                }
                catch (IOException iOException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                }
                finally {
                    this.connmgr.releaseConnection(nHttpClientConnection, null, 0L, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    final void discardConnection() {
        NHttpClientConnection nHttpClientConnection = this.managedConnRef.getAndSet(null);
        if (nHttpClientConnection != null) {
            try {
                nHttpClientConnection.shutdown();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + this.id + "] connection aborted"));
                }
            }
            catch (IOException iOException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)iOException.getMessage(), (Throwable)iOException);
                }
            }
            finally {
                this.connmgr.releaseConnection(nHttpClientConnection, null, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    final boolean manageConnectionPersistence() {
        boolean bl;
        HttpResponse httpResponse = this.responseRef.get();
        Asserts.check(httpResponse != null, "Inconsistent state: HTTP response");
        NHttpClientConnection nHttpClientConnection = this.managedConnRef.get();
        Asserts.check(nHttpClientConnection != null, "Inconsistent state: managed connection is null");
        boolean bl2 = bl = nHttpClientConnection.isOpen() && this.connReuseStrategy.keepAlive(httpResponse, this.localContext);
        if (bl) {
            long l = this.keepaliveStrategy.getKeepAliveDuration(httpResponse, this.localContext);
            if (this.log.isDebugEnabled()) {
                String string = l > 0L ? "for " + l + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                this.log.debug((Object)("[exchange: " + this.id + "] Connection can be kept alive " + string));
            }
            this.validDurationRef.set(l);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] Connection cannot be kept alive"));
            }
            this.validDurationRef.set(null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionAllocated(NHttpClientConnection nHttpClientConnection) {
        try {
            HttpContext httpContext;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] Connection allocated: " + nHttpClientConnection));
            }
            this.managedConnRef.set(nHttpClientConnection);
            if (this.closed.get()) {
                this.discardConnection();
                return;
            }
            HttpContext httpContext2 = httpContext = nHttpClientConnection.getContext();
            synchronized (httpContext2) {
                httpContext.setAttribute("http.nio.exchange-handler", this);
                if (nHttpClientConnection.isStale()) {
                    this.failed(new ConnectionClosedException("Connection closed"));
                } else {
                    nHttpClientConnection.requestOutput();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    private void connectionRequestFailed(Exception exception) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] connection request failed"));
        }
        this.failed(exception);
    }

    private void connectionRequestCancelled() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Connection request cancelled"));
        }
        try {
            this.resultFuture.cancel();
        }
        finally {
            this.close();
        }
    }

    final void requestConnection() {
        HttpRoute httpRoute = this.routeRef.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Request connection for " + httpRoute));
        }
        this.discardConnection();
        this.validDurationRef.set(null);
        this.routeTrackerRef.set(null);
        this.routeEstablished.set(false);
        Object object = this.localContext.getUserToken();
        RequestConfig requestConfig = this.localContext.getRequestConfig();
        this.connmgr.requestConnection(httpRoute, object, requestConfig.getConnectTimeout(), requestConfig.getConnectionRequestTimeout(), TimeUnit.MILLISECONDS, new FutureCallback<NHttpClientConnection>(){

            @Override
            public void completed(NHttpClientConnection nHttpClientConnection) {
                AbstractClientExchangeHandler.this.connectionAllocated(nHttpClientConnection);
            }

            @Override
            public void failed(Exception exception) {
                AbstractClientExchangeHandler.this.connectionRequestFailed(exception);
            }

            @Override
            public void cancelled() {
                AbstractClientExchangeHandler.this.connectionRequestCancelled();
            }
        });
    }

    abstract void releaseResources();

    abstract void executionFailed(Exception var1);

    abstract boolean executionCancelled();

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.discardConnection();
            this.releaseResources();
        }
    }

    @Override
    public final boolean isDone() {
        return this.completed.get();
    }

    @Override
    public final void failed(Exception exception) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                try {
                    this.executionFailed(exception);
                }
                finally {
                    this.discardConnection();
                    this.releaseResources();
                }
            }
            finally {
                this.resultFuture.failed(exception);
            }
        }
    }

    @Override
    public final boolean cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Cancelled"));
        }
        if (this.closed.compareAndSet(false, true)) {
            try {
                try {
                    boolean bl = this.executionCancelled();
                    this.discardConnection();
                    this.releaseResources();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.discardConnection();
                    this.releaseResources();
                    throw throwable;
                }
            }
            finally {
                this.resultFuture.cancel();
            }
        }
        return false;
    }
}

