/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.client.ClientProtocolException;
import com.icbc.api.internal.apache.http.client.methods.HttpUriRequest;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.client.utils.URIUtils;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.nio.client.HttpAsyncClient;
import com.icbc.api.internal.apache.http.nio.client.methods.HttpAsyncMethods;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, FutureCallback<T> futureCallback) {
        return this.execute(httpAsyncRequestProducer, httpAsyncResponseConsumer, (HttpContext)HttpClientContext.create(), futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext, FutureCallback<HttpResponse> futureCallback) {
        return this.execute(HttpAsyncMethods.create(httpHost, httpRequest), HttpAsyncMethods.createConsumer(), httpContext, futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest, FutureCallback<HttpResponse> futureCallback) {
        return this.execute(httpHost, httpRequest, (HttpContext)HttpClientContext.create(), futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest httpUriRequest, FutureCallback<HttpResponse> futureCallback) {
        return this.execute(httpUriRequest, HttpClientContext.create(), futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest httpUriRequest, HttpContext httpContext, FutureCallback<HttpResponse> futureCallback) {
        HttpHost httpHost;
        try {
            httpHost = this.determineTarget(httpUriRequest);
        }
        catch (ClientProtocolException clientProtocolException) {
            BasicFuture<HttpResponse> basicFuture = new BasicFuture<HttpResponse>(futureCallback);
            basicFuture.failed(clientProtocolException);
            return basicFuture;
        }
        return this.execute(httpHost, httpUriRequest, httpContext, futureCallback);
    }

    private HttpHost determineTarget(HttpUriRequest httpUriRequest) throws ClientProtocolException {
        Args.notNull(httpUriRequest, "HTTP request");
        HttpHost httpHost = null;
        URI uRI = httpUriRequest.getURI();
        if (uRI.isAbsolute() && (httpHost = URIUtils.extractHost(uRI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + uRI);
        }
        return httpHost;
    }
}

