/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.auth.AuthProtocolState;
import com.icbc.api.internal.apache.http.auth.AuthState;
import com.icbc.api.internal.apache.http.auth.UsernamePasswordCredentials;
import com.icbc.api.internal.apache.http.client.AuthenticationStrategy;
import com.icbc.api.internal.apache.http.client.CredentialsProvider;
import com.icbc.api.internal.apache.http.client.NonRepeatableRequestException;
import com.icbc.api.internal.apache.http.client.RedirectException;
import com.icbc.api.internal.apache.http.client.RedirectStrategy;
import com.icbc.api.internal.apache.http.client.UserTokenHandler;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.methods.AbortableHttpRequest;
import com.icbc.api.internal.apache.http.client.methods.HttpUriRequest;
import com.icbc.api.internal.apache.http.client.params.HttpClientParams;
import com.icbc.api.internal.apache.http.client.utils.URIUtils;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.conn.ConnectionReleaseTrigger;
import com.icbc.api.internal.apache.http.conn.routing.BasicRouteDirector;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.HttpRouteDirector;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoutePlanner;
import com.icbc.api.internal.apache.http.conn.routing.RouteInfo;
import com.icbc.api.internal.apache.http.impl.auth.BasicScheme;
import com.icbc.api.internal.apache.http.impl.client.ClientParamsStack;
import com.icbc.api.internal.apache.http.impl.client.EntityEnclosingRequestWrapper;
import com.icbc.api.internal.apache.http.impl.client.HttpAuthenticator;
import com.icbc.api.internal.apache.http.impl.client.RequestWrapper;
import com.icbc.api.internal.apache.http.impl.client.RoutedRequest;
import com.icbc.api.internal.apache.http.impl.nio.client.ParamConfig;
import com.icbc.api.internal.apache.http.impl.nio.client.ResultCallback;
import com.icbc.api.internal.apache.http.message.AbstractHttpMessage;
import com.icbc.api.internal.apache.http.message.BasicHttpRequest;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.conn.ClientAsyncConnectionManager;
import com.icbc.api.internal.apache.http.nio.conn.ManagedClientAsyncConnection;
import com.icbc.api.internal.apache.http.nio.conn.scheme.AsyncScheme;
import com.icbc.api.internal.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestExecutionHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.params.HttpConnectionParams;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.params.HttpProtocolParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;

@Deprecated
class DefaultAsyncRequestDirector<T>
implements HttpAsyncRequestExecutionHandler<T> {
    private static final AtomicLong COUNTER = new AtomicLong(1L);
    private final Log log;
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final HttpContext localContext;
    private final ResultCallback<T> resultCallback;
    private final ClientAsyncConnectionManager connmgr;
    private final HttpProcessor httppocessor;
    private final HttpRoutePlanner routePlanner;
    private final HttpRouteDirector routeDirector;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;
    private final RedirectStrategy redirectStrategy;
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final UserTokenHandler userTokenHandler;
    private final AuthState targetAuthState;
    private final AuthState proxyAuthState;
    private final HttpAuthenticator authenticator;
    private final HttpParams clientParams;
    private final long id;
    private volatile boolean closed;
    private volatile InternalFutureCallback connRequestCallback;
    private volatile ManagedClientAsyncConnection managedConn;
    private RoutedRequest mainRequest;
    private RoutedRequest followup;
    private HttpResponse finalResponse;
    private ClientParamsStack params;
    private RequestWrapper currentRequest;
    private HttpResponse currentResponse;
    private boolean routeEstablished;
    private int redirectCount;
    private ByteBuffer tmpbuf;
    private boolean requestContentProduced;
    private boolean requestSent;
    private int execCount;

    public DefaultAsyncRequestDirector(Log log, HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpContext httpContext, ResultCallback<T> resultCallback, ClientAsyncConnectionManager clientAsyncConnectionManager, HttpProcessor httpProcessor, HttpRoutePlanner httpRoutePlanner, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, RedirectStrategy redirectStrategy, AuthenticationStrategy authenticationStrategy, AuthenticationStrategy authenticationStrategy2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        this.log = log;
        this.requestProducer = httpAsyncRequestProducer;
        this.responseConsumer = httpAsyncResponseConsumer;
        this.localContext = httpContext;
        this.resultCallback = resultCallback;
        this.connmgr = clientAsyncConnectionManager;
        this.httppocessor = httpProcessor;
        this.routePlanner = httpRoutePlanner;
        this.reuseStrategy = connectionReuseStrategy;
        this.keepaliveStrategy = connectionKeepAliveStrategy;
        this.redirectStrategy = redirectStrategy;
        this.routeDirector = new BasicRouteDirector();
        this.targetAuthStrategy = authenticationStrategy;
        this.proxyAuthStrategy = authenticationStrategy2;
        this.userTokenHandler = userTokenHandler;
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
        this.authenticator = new HttpAuthenticator(log);
        this.clientParams = httpParams;
        this.id = COUNTER.getAndIncrement();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ManagedClientAsyncConnection managedClientAsyncConnection = this.managedConn;
        if (managedClientAsyncConnection != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] aborting connection " + managedClientAsyncConnection));
            }
            try {
                managedClientAsyncConnection.abortConnection();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"I/O error releasing connection", (Throwable)iOException);
            }
        }
        try {
            this.requestProducer.close();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing request producer", (Throwable)iOException);
        }
        try {
            this.responseConsumer.close();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing response consumer", (Throwable)iOException);
        }
    }

    public synchronized void start() {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] start execution"));
            }
            this.localContext.setAttribute("http.auth.target-scope", this.targetAuthState);
            this.localContext.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
            HttpHost httpHost = this.requestProducer.getTarget();
            HttpRequest httpRequest = this.requestProducer.generateRequest();
            if (httpRequest instanceof AbortableHttpRequest) {
                ((AbortableHttpRequest)((Object)httpRequest)).setReleaseTrigger(new ConnectionReleaseTrigger(){

                    @Override
                    public void releaseConnection() throws IOException {
                    }

                    @Override
                    public void abortConnection() throws IOException {
                        DefaultAsyncRequestDirector.this.cancel();
                    }
                });
            }
            this.params = new ClientParamsStack(null, this.clientParams, httpRequest.getParams(), null);
            RequestWrapper requestWrapper = this.wrapRequest(httpRequest);
            requestWrapper.setParams(this.params);
            HttpRoute httpRoute = this.determineRoute(httpHost, requestWrapper, this.localContext);
            this.mainRequest = new RoutedRequest(requestWrapper, httpRoute);
            RequestConfig requestConfig = ParamConfig.getRequestConfig(this.params);
            this.localContext.setAttribute("http.request-config", requestConfig);
            this.requestContentProduced = false;
            this.requestConnection();
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    @Override
    public HttpHost getTarget() {
        return this.requestProducer.getTarget();
    }

    @Override
    public synchronized HttpRequest generateRequest() throws IOException, HttpException {
        HttpHost httpHost;
        Object object;
        Cloneable cloneable;
        HttpRoute httpRoute = this.mainRequest.getRoute();
        if (!this.routeEstablished) {
            int n;
            do {
                cloneable = this.managedConn.getRoute();
                n = this.routeDirector.nextStep(httpRoute, (RouteInfo)((Object)cloneable));
                switch (n) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("[exchange: " + this.id + "] Tunnel required"));
                        }
                        object = this.createConnectRequest(httpRoute);
                        this.currentRequest = this.wrapRequest((HttpRequest)object);
                        this.currentRequest.setParams(this.params);
                        break;
                    }
                    case 4: {
                        throw new HttpException("Proxy chains are not supported");
                    }
                    case 5: {
                        this.managedConn.layerProtocol(this.localContext, this.params);
                        break;
                    }
                    case -1: {
                        throw new HttpException("Unable to establish route: planned = " + httpRoute + "; current = " + cloneable);
                    }
                    case 0: {
                        this.routeEstablished = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown step indicator " + n + " from RouteDirector.");
                    }
                }
            } while (n > 0 && this.currentRequest == null);
        }
        if ((httpHost = (HttpHost)this.params.getParameter("http.virtual-host")) == null) {
            httpHost = httpRoute.getTargetHost();
        }
        cloneable = httpRoute.getProxyHost();
        this.localContext.setAttribute("http.target_host", httpHost);
        this.localContext.setAttribute("http.proxy_host", cloneable);
        this.localContext.setAttribute("http.connection", this.managedConn);
        this.localContext.setAttribute("http.route", httpRoute);
        if (this.currentRequest == null) {
            this.currentRequest = this.mainRequest.getRequest();
            object = this.currentRequest.getURI().getUserInfo();
            if (object != null) {
                this.targetAuthState.update(new BasicScheme(), new UsernamePasswordCredentials((String)object));
            }
            this.rewriteRequestURI(this.currentRequest, httpRoute);
        }
        this.currentRequest.resetHeaders();
        this.currentRequest.incrementExecCount();
        if (this.currentRequest.getExecCount() > 1 && !this.requestProducer.isRepeatable() && this.requestContentProduced) {
            throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
        }
        ++this.execCount;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Attempt " + this.execCount + " to execute request"));
        }
        return this.currentRequest;
    }

    @Override
    public synchronized void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] produce content"));
        }
        this.requestContentProduced = true;
        this.requestProducer.produceContent(contentEncoder, iOControl);
        if (contentEncoder.isCompleted()) {
            this.requestProducer.resetRequest();
        }
    }

    @Override
    public void requestCompleted(HttpContext httpContext) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Request completed"));
        }
        this.requestSent = true;
        this.requestProducer.requestCompleted(httpContext);
    }

    @Override
    public boolean isRepeatable() {
        return this.requestProducer.isRepeatable();
    }

    @Override
    public void resetRequest() throws IOException {
        this.requestSent = false;
        this.requestProducer.resetRequest();
    }

    @Override
    public synchronized void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Response received " + httpResponse.getStatusLine()));
        }
        this.currentResponse = httpResponse;
        this.currentResponse.setParams(this.params);
        int n = this.currentResponse.getStatusLine().getStatusCode();
        if (!this.routeEstablished) {
            String string = this.currentRequest.getMethod();
            if (string.equalsIgnoreCase("CONNECT") && n == 200) {
                this.managedConn.tunnelTarget(this.params);
            } else {
                this.followup = this.handleConnectResponse();
                if (this.followup == null) {
                    this.finalResponse = httpResponse;
                }
            }
        } else {
            this.followup = this.handleResponse();
            if (this.followup == null) {
                this.finalResponse = httpResponse;
            }
            Object object = this.localContext.getAttribute("http.user-token");
            if (this.managedConn != null) {
                if (object == null) {
                    object = this.userTokenHandler.getUserToken(this.localContext);
                    this.localContext.setAttribute("http.user-token", object);
                }
                if (object != null) {
                    this.managedConn.setState(object);
                }
            }
        }
        if (this.finalResponse != null) {
            this.responseConsumer.responseReceived(httpResponse);
        }
    }

    @Override
    public synchronized void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Consume content"));
        }
        if (this.finalResponse != null) {
            this.responseConsumer.consumeContent(contentDecoder, iOControl);
        } else {
            if (this.tmpbuf == null) {
                this.tmpbuf = ByteBuffer.allocate(2048);
            }
            this.tmpbuf.clear();
            contentDecoder.read(this.tmpbuf);
        }
    }

    private void releaseConnection() {
        if (this.managedConn != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] releasing connection " + this.managedConn));
            }
            try {
                this.managedConn.getContext().removeAttribute("http.nio.exchange-handler");
                this.managedConn.releaseConnection();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"I/O error releasing connection", (Throwable)iOException);
            }
            this.managedConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void failed(Exception exception) {
        try {
            if (!this.requestSent) {
                this.requestProducer.failed(exception);
            }
            this.responseConsumer.failed(exception);
        }
        finally {
            try {
                this.resultCallback.failed(exception, this);
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public synchronized void responseCompleted(HttpContext httpContext) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Response fully read"));
        }
        try {
            if (this.resultCallback.isDone()) {
                return;
            }
            if (this.managedConn.isOpen()) {
                long l = this.keepaliveStrategy.getKeepAliveDuration(this.currentResponse, this.localContext);
                if (this.log.isDebugEnabled()) {
                    String string = l > 0L ? "for " + l + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                    this.log.debug((Object)("[exchange: " + this.id + "] Connection can be kept alive " + string));
                }
                this.managedConn.setIdleDuration(l, TimeUnit.MILLISECONDS);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + this.id + "] Connection cannot be kept alive"));
                }
                this.managedConn.unmarkReusable();
                if (this.proxyAuthState.getState() == AuthProtocolState.SUCCESS && this.proxyAuthState.getAuthScheme() != null && this.proxyAuthState.getAuthScheme().isConnectionBased()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("[exchange: " + this.id + "] Resetting proxy auth state"));
                    }
                    this.proxyAuthState.reset();
                }
                if (this.targetAuthState.getState() == AuthProtocolState.SUCCESS && this.targetAuthState.getAuthScheme() != null && this.targetAuthState.getAuthScheme().isConnectionBased()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("[exchange: " + this.id + "] Resetting target auth state"));
                    }
                    this.targetAuthState.reset();
                }
            }
            if (this.finalResponse != null) {
                this.responseConsumer.responseCompleted(this.localContext);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + this.id + "] Response processed"));
                }
                this.releaseConnection();
                T t = this.responseConsumer.getResult();
                Exception exception = this.responseConsumer.getException();
                if (exception == null) {
                    this.resultCallback.completed(t, this);
                } else {
                    this.resultCallback.failed(exception, this);
                }
            } else {
                if (this.followup != null) {
                    HttpRoute httpRoute;
                    HttpRoute httpRoute2 = this.mainRequest.getRoute();
                    if (!httpRoute2.equals(httpRoute = this.followup.getRoute())) {
                        this.releaseConnection();
                    }
                    this.mainRequest = this.followup;
                }
                if (this.managedConn != null && !this.managedConn.isOpen()) {
                    this.releaseConnection();
                }
                if (this.managedConn != null) {
                    this.managedConn.requestOutput();
                } else {
                    this.requestConnection();
                }
            }
            this.followup = null;
            this.currentRequest = null;
            this.currentResponse = null;
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public synchronized boolean cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Cancelled"));
        }
        try {
            boolean bl = this.responseConsumer.cancel();
            T t = this.responseConsumer.getResult();
            Exception exception = this.responseConsumer.getException();
            if (exception != null) {
                this.resultCallback.failed(exception, this);
            } else if (t != null) {
                this.resultCallback.completed(t, this);
            } else {
                this.resultCallback.cancelled(this);
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (RuntimeException runtimeException) {
            this.resultCallback.failed(runtimeException, this);
            throw runtimeException;
        }
        finally {
            this.close();
        }
    }

    @Override
    public boolean isDone() {
        return this.resultCallback.isDone();
    }

    @Override
    public T getResult() {
        return this.responseConsumer.getResult();
    }

    @Override
    public Exception getException() {
        return this.responseConsumer.getException();
    }

    private synchronized void connectionRequestCompleted(ManagedClientAsyncConnection managedClientAsyncConnection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Connection allocated: " + managedClientAsyncConnection));
        }
        this.connRequestCallback = null;
        try {
            this.managedConn = managedClientAsyncConnection;
            if (this.closed) {
                managedClientAsyncConnection.releaseConnection();
                return;
            }
            HttpRoute httpRoute = this.mainRequest.getRoute();
            if (!managedClientAsyncConnection.isOpen()) {
                managedClientAsyncConnection.open(httpRoute, this.localContext, this.params);
            }
            managedClientAsyncConnection.getContext().setAttribute("http.nio.exchange-handler", this);
            managedClientAsyncConnection.requestOutput();
            this.routeEstablished = httpRoute.equals(managedClientAsyncConnection.getRoute());
            if (!managedClientAsyncConnection.isOpen()) {
                throw new ConnectionClosedException("Connection closed");
            }
        }
        catch (IOException iOException) {
            this.failed(iOException);
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    private synchronized void connectionRequestFailed(Exception exception) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] connection request failed"));
        }
        this.connRequestCallback = null;
        try {
            this.resultCallback.failed(exception, this);
        }
        finally {
            this.close();
        }
    }

    private synchronized void connectionRequestCancelled() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Connection request cancelled"));
        }
        this.connRequestCallback = null;
        try {
            this.resultCallback.cancelled(this);
        }
        finally {
            this.close();
        }
    }

    private void requestConnection() {
        HttpRoute httpRoute = this.mainRequest.getRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Request connection for " + httpRoute));
        }
        long l = HttpConnectionParams.getConnectionTimeout(this.params);
        Object object = this.localContext.getAttribute("http.user-token");
        this.connRequestCallback = new InternalFutureCallback();
        this.connmgr.leaseConnection(httpRoute, object, l, TimeUnit.MILLISECONDS, this.connRequestCallback);
    }

    public synchronized void endOfStream() {
        if (this.managedConn != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] Unexpected end of data stream"));
            }
            this.releaseConnection();
            if (this.connRequestCallback == null) {
                this.requestConnection();
            }
        }
    }

    protected HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        HttpHost httpHost2;
        HttpHost httpHost3 = httpHost2 = httpHost != null ? httpHost : (HttpHost)httpRequest.getParams().getParameter("http.default-host");
        if (httpHost2 == null) {
            throw new IllegalStateException("Target host could not be resolved");
        }
        return this.routePlanner.determineRoute(httpHost2, httpRequest, httpContext);
    }

    private RequestWrapper wrapRequest(HttpRequest httpRequest) throws ProtocolException {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)httpRequest);
        }
        return new RequestWrapper(httpRequest);
    }

    protected void rewriteRequestURI(RequestWrapper requestWrapper, HttpRoute httpRoute) throws ProtocolException {
        try {
            URI uRI = requestWrapper.getURI();
            if (httpRoute.getProxyHost() != null && !httpRoute.isTunnelled()) {
                if (!uRI.isAbsolute()) {
                    HttpHost httpHost = httpRoute.getTargetHost();
                    uRI = URIUtils.rewriteURI(uRI, httpHost);
                    requestWrapper.setURI(uRI);
                }
            } else if (uRI.isAbsolute()) {
                uRI = URIUtils.rewriteURI(uRI, null);
                requestWrapper.setURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + requestWrapper.getRequestLine().getUri(), uRISyntaxException);
        }
    }

    private AsyncSchemeRegistry getSchemeRegistry(HttpContext httpContext) {
        AsyncSchemeRegistry asyncSchemeRegistry = (AsyncSchemeRegistry)httpContext.getAttribute("http.scheme-registry");
        if (asyncSchemeRegistry == null) {
            asyncSchemeRegistry = this.connmgr.getSchemeRegistry();
        }
        return asyncSchemeRegistry;
    }

    private HttpRequest createConnectRequest(HttpRoute httpRoute) {
        Object object;
        Object object2;
        HttpHost httpHost = httpRoute.getTargetHost();
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        if (n < 0) {
            object2 = this.getSchemeRegistry(this.localContext);
            object = ((AsyncSchemeRegistry)object2).getScheme(httpHost.getSchemeName());
            n = ((AsyncScheme)object).getDefaultPort();
        }
        object2 = new StringBuilder(string.length() + 6);
        ((StringBuilder)object2).append(string);
        ((StringBuilder)object2).append(':');
        ((StringBuilder)object2).append(Integer.toString(n));
        object = HttpProtocolParams.getVersion(this.params);
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest("CONNECT", ((StringBuilder)object2).toString(), (ProtocolVersion)object);
        return basicHttpRequest;
    }

    private RoutedRequest handleResponse() throws HttpException {
        CredentialsProvider credentialsProvider;
        RoutedRequest routedRequest = null;
        if (HttpClientParams.isAuthenticating(this.params) && (credentialsProvider = (CredentialsProvider)this.localContext.getAttribute("http.auth.credentials-provider")) != null) {
            routedRequest = this.handleTargetChallenge(credentialsProvider);
            if (routedRequest != null) {
                return routedRequest;
            }
            routedRequest = this.handleProxyChallenge(credentialsProvider);
            if (routedRequest != null) {
                return routedRequest;
            }
        }
        if (HttpClientParams.isRedirecting(this.params) && (routedRequest = this.handleRedirect()) != null) {
            return routedRequest;
        }
        return null;
    }

    private RoutedRequest handleConnectResponse() throws HttpException {
        CredentialsProvider credentialsProvider;
        RoutedRequest routedRequest = null;
        if (HttpClientParams.isAuthenticating(this.params) && (credentialsProvider = (CredentialsProvider)this.localContext.getAttribute("http.auth.credentials-provider")) != null && (routedRequest = this.handleProxyChallenge(credentialsProvider)) != null) {
            return routedRequest;
        }
        return null;
    }

    private RoutedRequest handleRedirect() throws HttpException {
        if (this.redirectStrategy.isRedirected(this.currentRequest, this.currentResponse, this.localContext)) {
            Object object;
            HttpRoute httpRoute = this.mainRequest.getRoute();
            RequestWrapper requestWrapper = this.mainRequest.getRequest();
            int n = this.params.getIntParameter("http.protocol.max-redirects", 100);
            if (this.redirectCount >= n) {
                throw new RedirectException("Maximum redirects (" + n + ") exceeded");
            }
            ++this.redirectCount;
            HttpUriRequest httpUriRequest = this.redirectStrategy.getRedirect(this.currentRequest, this.currentResponse, this.localContext);
            HttpRequest httpRequest = requestWrapper.getOriginal();
            httpUriRequest.setHeaders(httpRequest.getAllHeaders());
            URI uRI = httpUriRequest.getURI();
            if (uRI.getHost() == null) {
                throw new ProtocolException("Redirect URI does not specify a valid host name: " + uRI);
            }
            HttpHost httpHost = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
            if (!httpRoute.getTargetHost().equals(httpHost)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + this.id + "] Resetting target auth state"));
                }
                this.targetAuthState.reset();
                object = this.proxyAuthState.getAuthScheme();
                if (object != null && object.isConnectionBased()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("[exchange: " + this.id + "] Resetting proxy auth state"));
                    }
                    this.proxyAuthState.reset();
                }
            }
            object = this.wrapRequest(httpUriRequest);
            ((AbstractHttpMessage)object).setParams(this.params);
            HttpRoute httpRoute2 = this.determineRoute(httpHost, (HttpRequest)object, this.localContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] Redirecting to '" + uRI + "' via " + httpRoute2));
            }
            return new RoutedRequest((RequestWrapper)object, httpRoute2);
        }
        return null;
    }

    private RoutedRequest handleTargetChallenge(CredentialsProvider credentialsProvider) throws HttpException {
        HttpRoute httpRoute = this.mainRequest.getRoute();
        HttpHost httpHost = (HttpHost)this.localContext.getAttribute("http.target_host");
        if (httpHost == null) {
            httpHost = httpRoute.getTargetHost();
        }
        if (this.authenticator.isAuthenticationRequested(httpHost, this.currentResponse, this.targetAuthStrategy, this.targetAuthState, this.localContext)) {
            if (this.authenticator.authenticate(httpHost, this.currentResponse, this.targetAuthStrategy, this.targetAuthState, this.localContext)) {
                return this.mainRequest;
            }
            return null;
        }
        return null;
    }

    private RoutedRequest handleProxyChallenge(CredentialsProvider credentialsProvider) throws HttpException {
        HttpRoute httpRoute = this.mainRequest.getRoute();
        HttpHost httpHost = httpRoute.getProxyHost();
        if (this.authenticator.isAuthenticationRequested(httpHost, this.currentResponse, this.proxyAuthStrategy, this.proxyAuthState, this.localContext)) {
            if (this.authenticator.authenticate(httpHost, this.currentResponse, this.proxyAuthStrategy, this.proxyAuthState, this.localContext)) {
                return this.mainRequest;
            }
            return null;
        }
        return null;
    }

    @Override
    public HttpContext getContext() {
        return this.localContext;
    }

    @Override
    public HttpProcessor getHttpProcessor() {
        return this.httppocessor;
    }

    @Override
    public ConnectionReuseStrategy getConnectionReuseStrategy() {
        return this.reuseStrategy;
    }

    class InternalFutureCallback
    implements FutureCallback<ManagedClientAsyncConnection> {
        InternalFutureCallback() {
        }

        @Override
        public void completed(ManagedClientAsyncConnection managedClientAsyncConnection) {
            DefaultAsyncRequestDirector.this.connectionRequestCompleted(managedClientAsyncConnection);
        }

        @Override
        public void failed(Exception exception) {
            DefaultAsyncRequestDirector.this.connectionRequestFailed(exception);
        }

        @Override
        public void cancelled() {
            DefaultAsyncRequestDirector.this.connectionRequestCancelled();
        }
    }
}

