/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.auth.AuthScheme;
import com.icbc.api.internal.apache.http.auth.AuthState;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.client.UserTokenHandler;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultAsyncUserTokenHandler
implements UserTokenHandler {
    public static final DefaultAsyncUserTokenHandler INSTANCE = new DefaultAsyncUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext httpContext) {
        SSLSession sSLSession;
        Object object;
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        Principal principal = null;
        AuthState authState = httpClientContext.getTargetAuthState();
        if (authState != null && (principal = DefaultAsyncUserTokenHandler.getAuthPrincipal(authState)) == null) {
            object = httpClientContext.getProxyAuthState();
            principal = DefaultAsyncUserTokenHandler.getAuthPrincipal((AuthState)object);
        }
        if (principal == null && (object = httpClientContext.getConnection()).isOpen() && object instanceof ManagedNHttpClientConnection && (sSLSession = ((ManagedNHttpClientConnection)object).getSSLSession()) != null) {
            principal = sSLSession.getLocalPrincipal();
        }
        return principal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials credentials;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme != null && authScheme.isComplete() && authScheme.isConnectionBased() && (credentials = authState.getCredentials()) != null) {
            return credentials.getUserPrincipal();
        }
        return null;
    }
}

