/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequestInterceptor;
import com.icbc.api.internal.apache.http.HttpResponseInterceptor;
import com.icbc.api.internal.apache.http.auth.AuthSchemeProvider;
import com.icbc.api.internal.apache.http.client.AuthenticationStrategy;
import com.icbc.api.internal.apache.http.client.CookieStore;
import com.icbc.api.internal.apache.http.client.CredentialsProvider;
import com.icbc.api.internal.apache.http.client.RedirectStrategy;
import com.icbc.api.internal.apache.http.client.UserTokenHandler;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.protocol.RequestAddCookies;
import com.icbc.api.internal.apache.http.client.protocol.RequestAuthCache;
import com.icbc.api.internal.apache.http.client.protocol.RequestClientConnControl;
import com.icbc.api.internal.apache.http.client.protocol.RequestDefaultHeaders;
import com.icbc.api.internal.apache.http.client.protocol.RequestExpectContinue;
import com.icbc.api.internal.apache.http.client.protocol.ResponseProcessCookies;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.config.Lookup;
import com.icbc.api.internal.apache.http.config.Registry;
import com.icbc.api.internal.apache.http.config.RegistryBuilder;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.conn.SchemePortResolver;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoutePlanner;
import com.icbc.api.internal.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.icbc.api.internal.apache.http.conn.ssl.X509HostnameVerifier;
import com.icbc.api.internal.apache.http.conn.util.PublicSuffixMatcher;
import com.icbc.api.internal.apache.http.conn.util.PublicSuffixMatcherLoader;
import com.icbc.api.internal.apache.http.cookie.CookieSpecProvider;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.NoConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.auth.BasicSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.DigestSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.KerberosSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.NTLMSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.SPNegoSchemeFactory;
import com.icbc.api.internal.apache.http.impl.client.BasicCookieStore;
import com.icbc.api.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.icbc.api.internal.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.client.DefaultRedirectStrategy;
import com.icbc.api.internal.apache.http.impl.client.NoopUserTokenHandler;
import com.icbc.api.internal.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.icbc.api.internal.apache.http.impl.client.TargetAuthenticationStrategy;
import com.icbc.api.internal.apache.http.impl.conn.DefaultProxyRoutePlanner;
import com.icbc.api.internal.apache.http.impl.conn.DefaultRoutePlanner;
import com.icbc.api.internal.apache.http.impl.conn.DefaultSchemePortResolver;
import com.icbc.api.internal.apache.http.impl.conn.SystemDefaultRoutePlanner;
import com.icbc.api.internal.apache.http.impl.cookie.DefaultCookieSpecProvider;
import com.icbc.api.internal.apache.http.impl.cookie.IgnoreSpecProvider;
import com.icbc.api.internal.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import com.icbc.api.internal.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.icbc.api.internal.apache.http.impl.nio.client.DefaultAsyncUserTokenHandler;
import com.icbc.api.internal.apache.http.impl.nio.client.IOReactorUtils;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalHttpAsyncClient;
import com.icbc.api.internal.apache.http.impl.nio.client.MainClientExec;
import com.icbc.api.internal.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.conn.NoopIOSessionStrategy;
import com.icbc.api.internal.apache.http.nio.conn.SchemeIOSessionStrategy;
import com.icbc.api.internal.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.protocol.HttpProcessorBuilder;
import com.icbc.api.internal.apache.http.protocol.RequestContent;
import com.icbc.api.internal.apache.http.protocol.RequestTargetHost;
import com.icbc.api.internal.apache.http.protocol.RequestUserAgent;
import com.icbc.api.internal.apache.http.ssl.SSLContexts;
import com.icbc.api.internal.apache.http.util.TextUtils;
import com.icbc.api.internal.apache.http.util.VersionInfo;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class HttpAsyncClientBuilder {
    private NHttpClientConnectionManager connManager;
    private boolean connManagerShared;
    private SchemePortResolver schemePortResolver;
    private SchemeIOSessionStrategy sslStrategy;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslcontext;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private AuthenticationStrategy targetAuthStrategy;
    private AuthenticationStrategy proxyAuthStrategy;
    private UserTokenHandler userTokenHandler;
    private HttpProcessor httpprocessor;
    private LinkedList<HttpRequestInterceptor> requestFirst;
    private LinkedList<HttpRequestInterceptor> requestLast;
    private LinkedList<HttpResponseInterceptor> responseFirst;
    private LinkedList<HttpResponseInterceptor> responseLast;
    private HttpRoutePlanner routePlanner;
    private RedirectStrategy redirectStrategy;
    private Lookup<AuthSchemeProvider> authSchemeRegistry;
    private Lookup<CookieSpecProvider> cookieSpecRegistry;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private String userAgent;
    private HttpHost proxy;
    private Collection<? extends Header> defaultHeaders;
    private IOReactorConfig defaultIOReactorConfig;
    private ConnectionConfig defaultConnectionConfig;
    private RequestConfig defaultRequestConfig;
    private ThreadFactory threadFactory;
    private NHttpClientEventHandler eventHandler;
    private PublicSuffixMatcher publicSuffixMatcher;
    private boolean systemProperties;
    private boolean cookieManagementDisabled;
    private boolean authCachingDisabled;
    private boolean connectionStateDisabled;
    private int maxConnTotal = 0;
    private int maxConnPerRoute = 0;

    public static HttpAsyncClientBuilder create() {
        return new HttpAsyncClientBuilder();
    }

    protected HttpAsyncClientBuilder() {
    }

    public final HttpAsyncClientBuilder setPublicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
        this.publicSuffixMatcher = publicSuffixMatcher;
        return this;
    }

    public final HttpAsyncClientBuilder setConnectionManager(NHttpClientConnectionManager nHttpClientConnectionManager) {
        this.connManager = nHttpClientConnectionManager;
        return this;
    }

    public final HttpAsyncClientBuilder setConnectionManagerShared(boolean bl) {
        this.connManagerShared = bl;
        return this;
    }

    public final HttpAsyncClientBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final HttpAsyncClientBuilder setMaxConnTotal(int n) {
        this.maxConnTotal = n;
        return this;
    }

    public final HttpAsyncClientBuilder setMaxConnPerRoute(int n) {
        this.maxConnPerRoute = n;
        return this;
    }

    public final HttpAsyncClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.reuseStrategy = connectionReuseStrategy;
        return this;
    }

    public final HttpAsyncClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.keepAliveStrategy = connectionKeepAliveStrategy;
        return this;
    }

    public final HttpAsyncClientBuilder setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.userTokenHandler = userTokenHandler;
        return this;
    }

    public final HttpAsyncClientBuilder setTargetAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.targetAuthStrategy = authenticationStrategy;
        return this;
    }

    public final HttpAsyncClientBuilder setProxyAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.proxyAuthStrategy = authenticationStrategy;
        return this;
    }

    public final HttpAsyncClientBuilder setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpprocessor = httpProcessor;
        return this;
    }

    public final HttpAsyncClientBuilder addInterceptorFirst(HttpResponseInterceptor httpResponseInterceptor) {
        if (httpResponseInterceptor == null) {
            return this;
        }
        if (this.responseFirst == null) {
            this.responseFirst = new LinkedList();
        }
        this.responseFirst.addFirst(httpResponseInterceptor);
        return this;
    }

    public final HttpAsyncClientBuilder addInterceptorLast(HttpResponseInterceptor httpResponseInterceptor) {
        if (httpResponseInterceptor == null) {
            return this;
        }
        if (this.responseLast == null) {
            this.responseLast = new LinkedList();
        }
        this.responseLast.addLast(httpResponseInterceptor);
        return this;
    }

    public final HttpAsyncClientBuilder addInterceptorFirst(HttpRequestInterceptor httpRequestInterceptor) {
        if (httpRequestInterceptor == null) {
            return this;
        }
        if (this.requestFirst == null) {
            this.requestFirst = new LinkedList();
        }
        this.requestFirst.addFirst(httpRequestInterceptor);
        return this;
    }

    public final HttpAsyncClientBuilder addInterceptorLast(HttpRequestInterceptor httpRequestInterceptor) {
        if (httpRequestInterceptor == null) {
            return this;
        }
        if (this.requestLast == null) {
            this.requestLast = new LinkedList();
        }
        this.requestLast.addLast(httpRequestInterceptor);
        return this;
    }

    public final HttpAsyncClientBuilder setRoutePlanner(HttpRoutePlanner httpRoutePlanner) {
        this.routePlanner = httpRoutePlanner;
        return this;
    }

    public final HttpAsyncClientBuilder setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> lookup) {
        this.authSchemeRegistry = lookup;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultCookieSpecRegistry(Lookup<CookieSpecProvider> lookup) {
        this.cookieSpecRegistry = lookup;
        return this;
    }

    public final HttpAsyncClientBuilder setUserAgent(String string) {
        this.userAgent = string;
        return this;
    }

    public final HttpAsyncClientBuilder setProxy(HttpHost httpHost) {
        this.proxy = httpHost;
        return this;
    }

    public final HttpAsyncClientBuilder setSSLStrategy(SchemeIOSessionStrategy schemeIOSessionStrategy) {
        this.sslStrategy = schemeIOSessionStrategy;
        return this;
    }

    public final HttpAsyncClientBuilder setSSLContext(SSLContext sSLContext) {
        this.sslcontext = sSLContext;
        return this;
    }

    @Deprecated
    public final HttpAsyncClientBuilder setHostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        this.hostnameVerifier = x509HostnameVerifier;
        return this;
    }

    public final HttpAsyncClientBuilder setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultHeaders(Collection<? extends Header> collection) {
        this.defaultHeaders = collection;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultIOReactorConfig(IOReactorConfig iOReactorConfig) {
        this.defaultIOReactorConfig = iOReactorConfig;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
        this.defaultConnectionConfig = connectionConfig;
        return this;
    }

    public final HttpAsyncClientBuilder setDefaultRequestConfig(RequestConfig requestConfig) {
        this.defaultRequestConfig = requestConfig;
        return this;
    }

    public final HttpAsyncClientBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public final HttpAsyncClientBuilder setEventHandler(NHttpClientEventHandler nHttpClientEventHandler) {
        this.eventHandler = nHttpClientEventHandler;
        return this;
    }

    public final HttpAsyncClientBuilder disableConnectionState() {
        this.connectionStateDisabled = true;
        return this;
    }

    public final HttpAsyncClientBuilder disableCookieManagement() {
        this.cookieManagementDisabled = true;
        return this;
    }

    public final HttpAsyncClientBuilder disableAuthCaching() {
        this.authCachingDisabled = true;
        return this;
    }

    public final HttpAsyncClientBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    private static String[] split(String string) {
        if (TextUtils.isBlank(string)) {
            return null;
        }
        return string.split(" *, *");
    }

    public CloseableHttpAsyncClient build() {
        RequestConfig requestConfig;
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Registry<AuthSchemeProvider> registry;
        Object object4;
        HttpProcessor httpProcessor;
        SchemePortResolver schemePortResolver;
        UserTokenHandler userTokenHandler;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        PublicSuffixMatcher publicSuffixMatcher = this.publicSuffixMatcher;
        if (publicSuffixMatcher == null) {
            publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        }
        if ((object9 = this.connManager) == null) {
            object8 = this.sslStrategy;
            if (object8 == null) {
                object7 = this.sslcontext;
                if (object7 == null) {
                    object7 = this.systemProperties ? SSLContexts.createSystemDefault() : SSLContexts.createDefault();
                }
                object6 = this.systemProperties ? HttpAsyncClientBuilder.split(System.getProperty("https.protocols")) : null;
                object5 = this.systemProperties ? HttpAsyncClientBuilder.split(System.getProperty("https.cipherSuites")) : null;
                HostnameVerifier hostnameVerifier = this.hostnameVerifier;
                if (hostnameVerifier == null) {
                    hostnameVerifier = new DefaultHostnameVerifier(publicSuffixMatcher);
                }
                object8 = new SSLIOSessionStrategy((SSLContext)object7, (String[])object6, (String[])object5, hostnameVerifier);
            }
            object7 = IOReactorUtils.create(this.defaultIOReactorConfig != null ? this.defaultIOReactorConfig : IOReactorConfig.DEFAULT, this.threadFactory);
            object6 = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)object7, RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)object8).build());
            if (this.defaultConnectionConfig != null) {
                ((PoolingNHttpClientConnectionManager)object6).setDefaultConnectionConfig(this.defaultConnectionConfig);
            }
            if (this.systemProperties) {
                object5 = System.getProperty("http.keepAlive", "true");
                if ("true".equalsIgnoreCase((String)object5)) {
                    object5 = System.getProperty("http.maxConnections", "5");
                    int n = Integer.parseInt((String)object5);
                    ((PoolingNHttpClientConnectionManager)object6).setDefaultMaxPerRoute(n);
                    ((PoolingNHttpClientConnectionManager)object6).setMaxTotal(2 * n);
                }
            } else {
                if (this.maxConnTotal > 0) {
                    ((PoolingNHttpClientConnectionManager)object6).setMaxTotal(this.maxConnTotal);
                }
                if (this.maxConnPerRoute > 0) {
                    ((PoolingNHttpClientConnectionManager)object6).setDefaultMaxPerRoute(this.maxConnPerRoute);
                }
            }
            object9 = object6;
        }
        if ((object8 = this.reuseStrategy) == null) {
            object8 = this.systemProperties ? ("true".equalsIgnoreCase((String)(object7 = System.getProperty("http.keepAlive", "true"))) ? DefaultConnectionReuseStrategy.INSTANCE : NoConnectionReuseStrategy.INSTANCE) : DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((object7 = this.keepAliveStrategy) == null) {
            object7 = DefaultConnectionKeepAliveStrategy.INSTANCE;
        }
        if ((object6 = this.targetAuthStrategy) == null) {
            object6 = TargetAuthenticationStrategy.INSTANCE;
        }
        if ((object5 = this.proxyAuthStrategy) == null) {
            object5 = ProxyAuthenticationStrategy.INSTANCE;
        }
        if ((userTokenHandler = this.userTokenHandler) == null) {
            userTokenHandler = !this.connectionStateDisabled ? DefaultAsyncUserTokenHandler.INSTANCE : NoopUserTokenHandler.INSTANCE;
        }
        if ((schemePortResolver = this.schemePortResolver) == null) {
            schemePortResolver = DefaultSchemePortResolver.INSTANCE;
        }
        if ((httpProcessor = this.httpprocessor) == null) {
            object4 = this.userAgent;
            if (object4 == null) {
                if (this.systemProperties) {
                    object4 = System.getProperty("http.agent");
                }
                if (object4 == null) {
                    object4 = VersionInfo.getUserAgent("Apache-HttpAsyncClient", "org.apache.http.nio.client", this.getClass());
                }
            }
            registry = HttpProcessorBuilder.create();
            if (this.requestFirst != null) {
                iterator = this.requestFirst.iterator();
                while (iterator.hasNext()) {
                    object3 = (HttpRequestInterceptor)iterator.next();
                    ((HttpProcessorBuilder)((Object)registry)).addFirst((HttpRequestInterceptor)object3);
                }
            }
            if (this.responseFirst != null) {
                iterator = this.responseFirst.iterator();
                while (iterator.hasNext()) {
                    object3 = (HttpResponseInterceptor)iterator.next();
                    ((HttpProcessorBuilder)((Object)registry)).addFirst((HttpResponseInterceptor)object3);
                }
            }
            ((HttpProcessorBuilder)((Object)registry)).addAll(new RequestDefaultHeaders(this.defaultHeaders), new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent((String)object4), new RequestExpectContinue());
            if (!this.cookieManagementDisabled) {
                ((HttpProcessorBuilder)((Object)registry)).add(new RequestAddCookies());
            }
            if (!this.authCachingDisabled) {
                ((HttpProcessorBuilder)((Object)registry)).add(new RequestAuthCache());
            }
            if (!this.cookieManagementDisabled) {
                ((HttpProcessorBuilder)((Object)registry)).add(new ResponseProcessCookies());
            }
            if (this.requestLast != null) {
                iterator = this.requestLast.iterator();
                while (iterator.hasNext()) {
                    object3 = (HttpRequestInterceptor)iterator.next();
                    ((HttpProcessorBuilder)((Object)registry)).addLast((HttpRequestInterceptor)object3);
                }
            }
            if (this.responseLast != null) {
                iterator = this.responseLast.iterator();
                while (iterator.hasNext()) {
                    object3 = (HttpResponseInterceptor)iterator.next();
                    ((HttpProcessorBuilder)((Object)registry)).addLast((HttpResponseInterceptor)object3);
                }
            }
            httpProcessor = ((HttpProcessorBuilder)((Object)registry)).build();
        }
        if ((object4 = this.routePlanner) == null) {
            object4 = this.proxy != null ? new DefaultProxyRoutePlanner(this.proxy, schemePortResolver) : (this.systemProperties ? new SystemDefaultRoutePlanner(schemePortResolver, ProxySelector.getDefault()) : new DefaultRoutePlanner(schemePortResolver));
        }
        if ((registry = this.authSchemeRegistry) == null) {
            registry = RegistryBuilder.create().register("Basic", new BasicSchemeFactory()).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory())).register("NTLM", (BasicSchemeFactory)((Object)new NTLMSchemeFactory())).register("Negotiate", (BasicSchemeFactory)((Object)new SPNegoSchemeFactory())).register("Kerberos", (BasicSchemeFactory)((Object)new KerberosSchemeFactory())).build();
        }
        if ((iterator = this.cookieSpecRegistry) == null) {
            object3 = new DefaultCookieSpecProvider(publicSuffixMatcher);
            object2 = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
            object = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
            iterator = RegistryBuilder.create().register("default", object3).register("best-match", object3).register("compatibility", object3).register("standard", object2).register("standard-strict", object).register("netscape", new NetscapeDraftSpecProvider()).register("ignoreCookies", new IgnoreSpecProvider()).build();
        }
        if ((object3 = this.cookieStore) == null) {
            object3 = new BasicCookieStore();
        }
        if ((object2 = this.credentialsProvider) == null) {
            object2 = new BasicCredentialsProvider();
        }
        if ((object = this.redirectStrategy) == null) {
            object = DefaultRedirectStrategy.INSTANCE;
        }
        if ((requestConfig = this.defaultRequestConfig) == null) {
            requestConfig = RequestConfig.DEFAULT;
        }
        MainClientExec mainClientExec = new MainClientExec(httpProcessor, (HttpRoutePlanner)object4, (RedirectStrategy)object, (AuthenticationStrategy)object6, (AuthenticationStrategy)object5, userTokenHandler);
        ThreadFactory threadFactory = null;
        NHttpClientEventHandler nHttpClientEventHandler = null;
        if (!this.connManagerShared) {
            threadFactory = this.threadFactory;
            if (threadFactory == null) {
                threadFactory = Executors.defaultThreadFactory();
            }
            if ((nHttpClientEventHandler = this.eventHandler) == null) {
                nHttpClientEventHandler = new HttpAsyncRequestExecutor();
            }
        }
        return new InternalHttpAsyncClient((NHttpClientConnectionManager)object9, (ConnectionReuseStrategy)object8, (ConnectionKeepAliveStrategy)object7, threadFactory, nHttpClientEventHandler, mainClientExec, (Lookup<CookieSpecProvider>)((Object)iterator), registry, (CookieStore)object3, (CredentialsProvider)object2, requestConfig);
    }
}

