/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpPipeliningClient;
import com.icbc.api.internal.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import com.icbc.api.internal.apache.http.impl.nio.client.MinimalHttpAsyncClientBuilder;
import com.icbc.api.internal.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.util.Args;

public class HttpAsyncClients {
    private HttpAsyncClients() {
    }

    public static HttpAsyncClientBuilder custom() {
        return HttpAsyncClientBuilder.create();
    }

    public static CloseableHttpAsyncClient createDefault() {
        return HttpAsyncClientBuilder.create().build();
    }

    public static CloseableHttpAsyncClient createSystem() {
        return HttpAsyncClientBuilder.create().useSystemProperties().build();
    }

    public static CloseableHttpAsyncClient createMinimal() {
        return MinimalHttpAsyncClientBuilder.create().disableCookieManagement().build();
    }

    public static CloseableHttpAsyncClient createMinimal(ConnectingIOReactor connectingIOReactor) {
        Args.notNull(connectingIOReactor, "I/O reactor");
        return HttpAsyncClients.createMinimal(new PoolingNHttpClientConnectionManager(connectingIOReactor), false);
    }

    public static CloseableHttpAsyncClient createMinimal(NHttpClientConnectionManager nHttpClientConnectionManager) {
        return HttpAsyncClients.createMinimal(nHttpClientConnectionManager, false);
    }

    public static CloseableHttpAsyncClient createMinimal(NHttpClientConnectionManager nHttpClientConnectionManager, boolean bl) {
        Args.notNull(nHttpClientConnectionManager, "Connection manager");
        return MinimalHttpAsyncClientBuilder.create().setConnectionManager(nHttpClientConnectionManager).setConnectionManagerShared(bl).disableCookieManagement().build();
    }

    public static CloseableHttpPipeliningClient createPipelining() {
        return MinimalHttpAsyncClientBuilder.create().build();
    }

    public static CloseableHttpPipeliningClient createPipelining(ConnectingIOReactor connectingIOReactor) {
        return HttpAsyncClients.createPipelining(new PoolingNHttpClientConnectionManager(connectingIOReactor), false);
    }

    public static CloseableHttpPipeliningClient createPipelining(NHttpClientConnectionManager nHttpClientConnectionManager) {
        return HttpAsyncClients.createPipelining(nHttpClientConnectionManager, false);
    }

    public static CloseableHttpPipeliningClient createPipelining(NHttpClientConnectionManager nHttpClientConnectionManager, boolean bl) {
        Args.notNull(nHttpClientConnectionManager, "Connection manager");
        return MinimalHttpAsyncClientBuilder.create().setConnectionManager(nHttpClientConnectionManager).setConnectionManagerShared(bl).build();
    }
}

