/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpAsyncClientBase;
import com.icbc.api.internal.apache.http.impl.nio.client.MinimalClientExchangeHandlerImpl;
import com.icbc.api.internal.apache.http.impl.nio.client.PipeliningClientExchangeHandlerImpl;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.BasicHttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MinimalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;

    public MinimalHttpAsyncClient(NHttpClientConnectionManager nHttpClientConnectionManager, ThreadFactory threadFactory, NHttpClientEventHandler nHttpClientEventHandler, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        super(nHttpClientConnectionManager, threadFactory, nHttpClientEventHandler);
        this.connmgr = nHttpClientConnectionManager;
        this.httpProcessor = httpProcessor;
        this.connReuseStrategy = connectionReuseStrategy;
        this.keepaliveStrategy = connectionKeepAliveStrategy;
    }

    public MinimalHttpAsyncClient(NHttpClientConnectionManager nHttpClientConnectionManager, HttpProcessor httpProcessor) {
        this(nHttpClientConnectionManager, Executors.defaultThreadFactory(), new HttpAsyncRequestExecutor(), httpProcessor, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpContext httpContext, FutureCallback<T> futureCallback) {
        this.ensureRunning();
        BasicFuture<T> basicFuture = new BasicFuture<T>(futureCallback);
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext != null ? httpContext : new BasicHttpContext());
        MinimalClientExchangeHandlerImpl<T> minimalClientExchangeHandlerImpl = new MinimalClientExchangeHandlerImpl<T>(this.log, httpAsyncRequestProducer, httpAsyncResponseConsumer, httpClientContext, basicFuture, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        try {
            minimalClientExchangeHandlerImpl.start();
        }
        catch (Exception exception) {
            minimalClientExchangeHandlerImpl.failed(exception);
        }
        return basicFuture;
    }

    @Override
    public <T> Future<List<T>> execute(HttpHost httpHost, List<? extends HttpAsyncRequestProducer> list, List<? extends HttpAsyncResponseConsumer<T>> list2, HttpContext httpContext, FutureCallback<List<T>> futureCallback) {
        this.ensureRunning();
        BasicFuture<List<T>> basicFuture = new BasicFuture<List<T>>(futureCallback);
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext != null ? httpContext : new BasicHttpContext());
        PipeliningClientExchangeHandlerImpl<T> pipeliningClientExchangeHandlerImpl = new PipeliningClientExchangeHandlerImpl<T>(this.log, httpHost, list, list2, httpClientContext, basicFuture, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        try {
            pipeliningClientExchangeHandlerImpl.start();
        }
        catch (Exception exception) {
            pipeliningClientExchangeHandlerImpl.failed(exception);
        }
        return basicFuture;
    }
}

