/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.methods.HttpRequestWrapper;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.nio.client.AbstractClientExchangeHandler;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.nio.protocol.Pipelined;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;

@Pipelined
class PipeliningClientExchangeHandlerImpl<T>
extends AbstractClientExchangeHandler {
    private final HttpHost target;
    private final Queue<HttpAsyncRequestProducer> requestProducerQueue;
    private final Queue<HttpAsyncResponseConsumer<T>> responseConsumerQueue;
    private final Queue<HttpRequest> requestQueue;
    private final Queue<T> resultQueue;
    private final HttpClientContext localContext;
    private final BasicFuture<List<T>> resultFuture;
    private final HttpProcessor httpProcessor;
    private final AtomicReference<HttpAsyncRequestProducer> requestProducerRef;
    private final AtomicReference<HttpAsyncResponseConsumer<T>> responseConsumerRef;

    public PipeliningClientExchangeHandlerImpl(Log log, HttpHost httpHost, List<? extends HttpAsyncRequestProducer> list, List<? extends HttpAsyncResponseConsumer<T>> list2, HttpClientContext httpClientContext, BasicFuture<List<T>> basicFuture, NHttpClientConnectionManager nHttpClientConnectionManager, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        super(log, httpClientContext, basicFuture, nHttpClientConnectionManager, connectionReuseStrategy, connectionKeepAliveStrategy);
        Args.notNull(httpHost, "HTTP target");
        Args.notEmpty(list, "Request producer list");
        Args.notEmpty(list2, "Response consumer list");
        Args.check(list.size() == list2.size(), "Number of request producers does not match that of response consumers");
        this.target = httpHost;
        this.requestProducerQueue = new ConcurrentLinkedQueue<HttpAsyncRequestProducer>(list);
        this.responseConsumerQueue = new ConcurrentLinkedQueue<HttpAsyncResponseConsumer<T>>(list2);
        this.requestQueue = new ConcurrentLinkedQueue<HttpRequest>();
        this.resultQueue = new ConcurrentLinkedQueue<T>();
        this.localContext = httpClientContext;
        this.resultFuture = basicFuture;
        this.httpProcessor = httpProcessor;
        this.requestProducerRef = new AtomicReference<Object>(null);
        this.responseConsumerRef = new AtomicReference<Object>(null);
    }

    private void closeProducer(HttpAsyncRequestProducer httpAsyncRequestProducer) {
        if (httpAsyncRequestProducer != null) {
            try {
                httpAsyncRequestProducer.close();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"I/O error closing request producer", (Throwable)iOException);
            }
        }
    }

    private void closeConsumer(HttpAsyncResponseConsumer<?> httpAsyncResponseConsumer) {
        if (httpAsyncResponseConsumer != null) {
            try {
                httpAsyncResponseConsumer.close();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"I/O error closing response consumer", (Throwable)iOException);
            }
        }
    }

    @Override
    void releaseResources() {
        this.closeProducer(this.requestProducerRef.getAndSet(null));
        this.closeConsumer(this.responseConsumerRef.getAndSet(null));
        while (!this.requestProducerQueue.isEmpty()) {
            this.closeProducer(this.requestProducerQueue.remove());
        }
        while (!this.responseConsumerQueue.isEmpty()) {
            this.closeConsumer(this.responseConsumerQueue.remove());
        }
        this.requestQueue.clear();
        this.resultQueue.clear();
    }

    @Override
    void executionFailed(Exception exception) {
        HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer;
        HttpAsyncRequestProducer httpAsyncRequestProducer = this.requestProducerRef.get();
        if (httpAsyncRequestProducer != null) {
            httpAsyncRequestProducer.failed(exception);
        }
        if ((httpAsyncResponseConsumer = this.responseConsumerRef.get()) != null) {
            httpAsyncResponseConsumer.failed(exception);
        }
        for (HttpAsyncResponseConsumer httpAsyncResponseConsumer2 : this.responseConsumerQueue) {
            httpAsyncResponseConsumer2.cancel();
        }
    }

    @Override
    boolean executionCancelled() {
        HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer = this.responseConsumerRef.get();
        boolean bl = httpAsyncResponseConsumer != null && httpAsyncResponseConsumer.cancel();
        this.resultFuture.cancel();
        return bl;
    }

    public void start() throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] start execution"));
        }
        HttpRoute httpRoute = new HttpRoute(this.target);
        this.setRoute(httpRoute);
        this.localContext.setAttribute("http.target_host", this.target);
        this.localContext.setAttribute("http.route", httpRoute);
        this.requestConnection();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        this.verifytRoute();
        if (!this.isRouteEstablished()) {
            this.onRouteToTarget();
            this.onRouteComplete();
        }
        NHttpClientConnection nHttpClientConnection = this.getConnection();
        this.localContext.setAttribute("http.connection", nHttpClientConnection);
        Asserts.check(this.requestProducerRef.get() == null, "Inconsistent state: currentRequest producer is not null");
        HttpAsyncRequestProducer httpAsyncRequestProducer = this.requestProducerQueue.poll();
        if (httpAsyncRequestProducer == null) {
            return null;
        }
        this.requestProducerRef.set(httpAsyncRequestProducer);
        HttpRequest httpRequest = httpAsyncRequestProducer.generateRequest();
        HttpRequestWrapper httpRequestWrapper = HttpRequestWrapper.wrap(httpRequest);
        RequestConfig requestConfig = this.localContext.getRequestConfig();
        if (requestConfig.getSocketTimeout() > 0) {
            nHttpClientConnection.setSocketTimeout(requestConfig.getSocketTimeout());
        }
        this.httpProcessor.process(httpRequestWrapper, (HttpContext)this.localContext);
        this.requestQueue.add(httpRequestWrapper);
        this.setCurrentRequest(httpRequestWrapper);
        return httpRequestWrapper;
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        HttpAsyncRequestProducer httpAsyncRequestProducer;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] produce content"));
        }
        Asserts.check((httpAsyncRequestProducer = this.requestProducerRef.get()) != null, "Inconsistent state: request producer is null");
        httpAsyncRequestProducer.produceContent(contentEncoder, iOControl);
        if (contentEncoder.isCompleted()) {
            httpAsyncRequestProducer.resetRequest();
        }
    }

    @Override
    public void requestCompleted() {
        HttpAsyncRequestProducer httpAsyncRequestProducer;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Request completed"));
        }
        Asserts.check((httpAsyncRequestProducer = (HttpAsyncRequestProducer)this.requestProducerRef.getAndSet(null)) != null, "Inconsistent state: request producer is null");
        httpAsyncRequestProducer.requestCompleted(this.localContext);
        try {
            httpAsyncRequestProducer.close();
        }
        catch (IOException iOException) {
            this.log.debug((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    @Override
    public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Response received " + httpResponse.getStatusLine()));
        }
        Asserts.check(this.responseConsumerRef.get() == null, "Inconsistent state: response consumer is not null");
        HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer = this.responseConsumerQueue.poll();
        Asserts.check(httpAsyncResponseConsumer != null, "Inconsistent state: response consumer queue is empty");
        this.responseConsumerRef.set(httpAsyncResponseConsumer);
        HttpRequest httpRequest = this.requestQueue.poll();
        Asserts.check(httpRequest != null, "Inconsistent state: request queue is empty");
        this.localContext.setAttribute("http.request", httpRequest);
        this.localContext.setAttribute("http.response", httpResponse);
        this.httpProcessor.process(httpResponse, (HttpContext)this.localContext);
        httpAsyncResponseConsumer.responseReceived(httpResponse);
        this.setCurrentResponse(httpResponse);
    }

    @Override
    public void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Consume content"));
        }
        Asserts.check((httpAsyncResponseConsumer = this.responseConsumerRef.get()) != null, "Inconsistent state: response consumer is null");
        httpAsyncResponseConsumer.consumeContent(contentDecoder, iOControl);
    }

    @Override
    public void responseCompleted() throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Response processed"));
        }
        boolean bl = this.manageConnectionPersistence();
        HttpAsyncResponseConsumer httpAsyncResponseConsumer = this.responseConsumerRef.getAndSet(null);
        Asserts.check(httpAsyncResponseConsumer != null, "Inconsistent state: response consumer is null");
        try {
            httpAsyncResponseConsumer.responseCompleted(this.localContext);
            Object t = httpAsyncResponseConsumer.getResult();
            Exception exception = httpAsyncResponseConsumer.getException();
            try {
                httpAsyncResponseConsumer.close();
            }
            catch (IOException iOException) {
                this.log.debug((Object)iOException.getMessage(), (Throwable)iOException);
            }
            if (t != null) {
                this.resultQueue.add(t);
            } else {
                this.failed(exception);
            }
            if (!this.resultFuture.isDone() && this.responseConsumerQueue.isEmpty()) {
                this.resultFuture.completed(new ArrayList<T>(this.resultQueue));
                this.resultQueue.clear();
            }
            if (this.resultFuture.isDone()) {
                this.close();
            } else if (!bl) {
                this.failed(new ConnectionClosedException("Connection closed"));
            } else {
                NHttpClientConnection nHttpClientConnection = this.getConnection();
                if (nHttpClientConnection != null) {
                    nHttpClientConnection.requestOutput();
                } else {
                    this.requestConnection();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void inputTerminated() {
        this.failed(new ConnectionClosedException("Connection closed"));
    }

    public void abortConnection() {
        this.discardConnection();
    }
}

