/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpMessage;
import com.icbc.api.internal.apache.http.MessageConstraintException;
import com.icbc.api.internal.apache.http.ParseException;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.message.BasicLineParser;
import com.icbc.api.internal.apache.http.message.LineParser;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParser;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMessageParser<T extends HttpMessage>
implements NHttpMessageParser<T> {
    private final SessionInputBuffer sessionBuffer;
    private static final int READ_HEAD_LINE = 0;
    private static final int READ_HEADERS = 1;
    private static final int COMPLETED = 2;
    private int state;
    private boolean endOfStream;
    private T message;
    private CharArrayBuffer lineBuf;
    private final List<CharArrayBuffer> headerBufs;
    protected final LineParser lineParser;
    private final MessageConstraints constraints;

    @Deprecated
    public AbstractMessageParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpParams httpParams) {
        Args.notNull(sessionInputBuffer, "Session input buffer");
        Args.notNull(httpParams, "HTTP parameters");
        this.sessionBuffer = sessionInputBuffer;
        this.state = 0;
        this.endOfStream = false;
        this.headerBufs = new ArrayList<CharArrayBuffer>();
        this.constraints = HttpParamConfig.getMessageConstraints(httpParams);
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
    }

    public AbstractMessageParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, MessageConstraints messageConstraints) {
        this.sessionBuffer = Args.notNull(sessionInputBuffer, "Session input buffer");
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.constraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.headerBufs = new ArrayList<CharArrayBuffer>();
        this.state = 0;
        this.endOfStream = false;
    }

    @Override
    public void reset() {
        this.state = 0;
        this.endOfStream = false;
        this.headerBufs.clear();
        this.message = null;
    }

    @Override
    public int fillBuffer(ReadableByteChannel readableByteChannel) throws IOException {
        int n = this.sessionBuffer.fill(readableByteChannel);
        if (n == -1) {
            this.endOfStream = true;
        }
        return n;
    }

    protected abstract T createMessage(CharArrayBuffer var1) throws HttpException, ParseException;

    private void parseHeadLine() throws HttpException, ParseException {
        this.message = this.createMessage(this.lineBuf);
    }

    private void parseHeader() throws IOException {
        CharArrayBuffer charArrayBuffer = this.lineBuf;
        int n = this.headerBufs.size();
        if ((this.lineBuf.charAt(0) == ' ' || this.lineBuf.charAt(0) == '\t') && n > 0) {
            int n2;
            int n3;
            CharArrayBuffer charArrayBuffer2 = this.headerBufs.get(n - 1);
            for (n3 = 0; n3 < charArrayBuffer.length() && ((n2 = charArrayBuffer.charAt(n3)) == 32 || n2 == 9); ++n3) {
            }
            n2 = this.constraints.getMaxLineLength();
            if (n2 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n3 > n2) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            charArrayBuffer2.append(' ');
            charArrayBuffer2.append(charArrayBuffer, n3, charArrayBuffer.length() - n3);
        } else {
            this.headerBufs.add(charArrayBuffer);
            this.lineBuf = null;
        }
    }

    @Override
    public T parse() throws IOException, HttpException {
        while (this.state != 2) {
            if (this.lineBuf == null) {
                this.lineBuf = new CharArrayBuffer(64);
            } else {
                this.lineBuf.clear();
            }
            boolean bl = this.sessionBuffer.readLine(this.lineBuf, this.endOfStream);
            int n = this.constraints.getMaxLineLength();
            if (n > 0 && (this.lineBuf.length() > n || !bl && this.sessionBuffer.length() > n)) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            if (!bl) break;
            switch (this.state) {
                case 0: {
                    try {
                        this.parseHeadLine();
                    }
                    catch (ParseException parseException) {
                        throw new ProtocolException(parseException.getMessage(), parseException);
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (this.lineBuf.length() > 0) {
                        int n2 = this.constraints.getMaxHeaderCount();
                        if (n2 > 0 && this.headerBufs.size() >= n2) {
                            throw new MessageConstraintException("Maximum header count exceeded");
                        }
                        this.parseHeader();
                        break;
                    }
                    this.state = 2;
                }
            }
            if (!this.endOfStream || this.sessionBuffer.hasData()) continue;
            this.state = 2;
        }
        if (this.state == 2) {
            for (CharArrayBuffer charArrayBuffer : this.headerBufs) {
                try {
                    this.message.addHeader(this.lineParser.parseHeader(charArrayBuffer));
                }
                catch (ParseException parseException) {
                    throw new ProtocolException(parseException.getMessage(), parseException);
                }
            }
            return this.message;
        }
        return null;
    }
}

