/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.MalformedChunkCodingException;
import com.icbc.api.internal.apache.http.MessageConstraintException;
import com.icbc.api.internal.apache.http.ParseException;
import com.icbc.api.internal.apache.http.TruncatedChunkException;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.impl.nio.codecs.AbstractContentDecoder;
import com.icbc.api.internal.apache.http.message.BufferedHeader;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;

public class ChunkDecoder
extends AbstractContentDecoder {
    private static final int READ_CONTENT = 0;
    private static final int READ_FOOTERS = 1;
    private static final int COMPLETED = 2;
    private int state = 0;
    private boolean endOfChunk = false;
    private boolean endOfStream = false;
    private CharArrayBuffer lineBuf;
    private long chunkSize = -1L;
    private long pos = 0L;
    private final MessageConstraints constraints;
    private final List<CharArrayBuffer> trailerBufs;
    private Header[] footers;

    public ChunkDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, MessageConstraints messageConstraints, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        super(readableByteChannel, sessionInputBuffer, httpTransportMetricsImpl);
        this.constraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.trailerBufs = new ArrayList<CharArrayBuffer>();
    }

    public ChunkDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        this(readableByteChannel, sessionInputBuffer, null, httpTransportMetricsImpl);
    }

    private void readChunkHead() throws IOException {
        if (this.lineBuf == null) {
            this.lineBuf = new CharArrayBuffer(32);
        } else {
            this.lineBuf.clear();
        }
        if (this.endOfChunk) {
            if (this.buffer.readLine(this.lineBuf, this.endOfStream)) {
                if (!this.lineBuf.isEmpty()) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
            } else {
                if (this.buffer.length() > 2 || this.endOfStream) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
                return;
            }
            this.endOfChunk = false;
        }
        boolean bl = this.buffer.readLine(this.lineBuf, this.endOfStream);
        int n = this.constraints.getMaxLineLength();
        if (n > 0 && (this.lineBuf.length() > n || !bl && this.buffer.length() > n)) {
            throw new MessageConstraintException("Maximum line length limit exceeded");
        }
        if (bl) {
            int n2 = this.lineBuf.indexOf(59);
            if (n2 < 0) {
                n2 = this.lineBuf.length();
            }
            String string = this.lineBuf.substringTrimmed(0, n2);
            try {
                this.chunkSize = Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedChunkCodingException("Bad chunk header: " + string);
            }
            this.pos = 0L;
        } else if (this.endOfStream) {
            throw new ConnectionClosedException("Premature end of chunk coded message body: closing chunk expected");
        }
    }

    private void parseHeader() throws IOException {
        CharArrayBuffer charArrayBuffer = this.lineBuf;
        int n = this.trailerBufs.size();
        if ((this.lineBuf.charAt(0) == ' ' || this.lineBuf.charAt(0) == '\t') && n > 0) {
            int n2;
            int n3;
            CharArrayBuffer charArrayBuffer2 = this.trailerBufs.get(n - 1);
            for (n3 = 0; n3 < charArrayBuffer.length() && ((n2 = charArrayBuffer.charAt(n3)) == 32 || n2 == 9); ++n3) {
            }
            n2 = this.constraints.getMaxLineLength();
            if (n2 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n3 > n2) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            charArrayBuffer2.append(' ');
            charArrayBuffer2.append(charArrayBuffer, n3, charArrayBuffer.length() - n3);
        } else {
            this.trailerBufs.add(charArrayBuffer);
            this.lineBuf = null;
        }
    }

    private void processFooters() throws IOException {
        int n = this.trailerBufs.size();
        if (n > 0) {
            this.footers = new Header[this.trailerBufs.size()];
            for (int i = 0; i < this.trailerBufs.size(); ++i) {
                try {
                    this.footers[i] = new BufferedHeader(this.trailerBufs.get(i));
                    continue;
                }
                catch (ParseException parseException) {
                    throw new IOException(parseException.getMessage());
                }
            }
        }
        this.trailerBufs.clear();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.state == 2) {
            return -1;
        }
        int n = 0;
        while (this.state != 2) {
            int n2;
            if (!(this.buffer.hasData() && this.chunkSize != -1L || (n2 = this.fillBufferFromChannel()) != -1)) {
                this.endOfStream = true;
            }
            switch (this.state) {
                case 0: {
                    long l;
                    int n3;
                    if (this.chunkSize == -1L) {
                        this.readChunkHead();
                        if (this.chunkSize == -1L) {
                            return n;
                        }
                        if (this.chunkSize == 0L) {
                            this.chunkSize = -1L;
                            this.state = 1;
                            break;
                        }
                    }
                    if ((n3 = this.buffer.read(byteBuffer, (int)Math.min(l = this.chunkSize - this.pos, Integer.MAX_VALUE))) > 0) {
                        this.pos += (long)n3;
                        n += n3;
                    } else if (!this.buffer.hasData() && this.endOfStream) {
                        this.state = 2;
                        this.completed = true;
                        throw new TruncatedChunkException("Truncated chunk ( expected size: " + this.chunkSize + "; actual size: " + this.pos + ")");
                    }
                    if (this.pos == this.chunkSize) {
                        this.chunkSize = -1L;
                        this.pos = 0L;
                        this.endOfChunk = true;
                        break;
                    }
                    return n;
                }
                case 1: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new CharArrayBuffer(32);
                    } else {
                        this.lineBuf.clear();
                    }
                    if (!this.buffer.readLine(this.lineBuf, this.endOfStream)) {
                        if (this.endOfStream) {
                            this.state = 2;
                            this.completed = true;
                        }
                        return n;
                    }
                    if (this.lineBuf.length() > 0) {
                        int n4 = this.constraints.getMaxHeaderCount();
                        if (n4 > 0 && this.trailerBufs.size() >= n4) {
                            throw new MessageConstraintException("Maximum header count exceeded");
                        }
                        this.parseHeader();
                        break;
                    }
                    this.state = 2;
                    this.completed = true;
                    this.processFooters();
                }
            }
        }
        return n;
    }

    public Header[] getFooters() {
        if (this.footers != null) {
            return (Header[])this.footers.clone();
        }
        return new Header[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[chunk-coded; completed: ");
        stringBuilder.append(this.completed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

