/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.impl.nio.codecs.AbstractContentDecoder;
import com.icbc.api.internal.apache.http.nio.FileContentDecoder;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

public class IdentityDecoder
extends AbstractContentDecoder
implements FileContentDecoder {
    public IdentityDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        super(readableByteChannel, sessionInputBuffer, httpTransportMetricsImpl);
    }

    public void setCompleted(boolean bl) {
        this.completed = bl;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.completed) {
            return -1;
        }
        int n = this.buffer.hasData() ? this.buffer.read(byteBuffer) : this.readFromChannel(byteBuffer);
        if (n == -1) {
            this.completed = true;
        }
        return n;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l, long l2) throws IOException {
        long l3;
        if (fileChannel == null) {
            return 0L;
        }
        if (this.completed) {
            return 0L;
        }
        if (this.buffer.hasData()) {
            fileChannel.position(l);
            l3 = this.buffer.read(fileChannel);
        } else {
            if (this.channel.isOpen()) {
                if (l > fileChannel.size()) {
                    throw new IOException("Position past end of file [" + l + " > " + fileChannel.size() + "]");
                }
                l3 = fileChannel.transferFrom(this.channel, l, l2);
                if (l2 > 0L && l3 == 0L) {
                    l3 = this.buffer.fill(this.channel);
                }
            } else {
                l3 = -1L;
            }
            if (l3 > 0L) {
                this.metrics.incrementBytesTransferred(l3);
            }
        }
        if (l3 == -1L) {
            this.completed = true;
        }
        return l3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[identity; completed: ");
        stringBuilder.append(this.completed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

