/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.impl.nio.codecs.AbstractContentEncoder;
import com.icbc.api.internal.apache.http.nio.FileContentEncoder;
import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class LengthDelimitedEncoder
extends AbstractContentEncoder
implements FileContentEncoder {
    private final long contentLength;
    private final int fragHint;
    private long remaining;

    public LengthDelimitedEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl, long l, int n) {
        super(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl);
        Args.notNegative(l, "Content length");
        this.contentLength = l;
        this.fragHint = n > 0 ? n : 0;
        this.remaining = l;
    }

    public LengthDelimitedEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl, long l) {
        this(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl, l, 0);
    }

    private int nextChunk(ByteBuffer byteBuffer) {
        return (int)Math.min(Math.min(this.remaining, Integer.MAX_VALUE), (long)byteBuffer.remaining());
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return 0;
        }
        this.assertNotCompleted();
        int n = 0;
        while (byteBuffer.hasRemaining() && this.remaining > 0L) {
            int n2;
            int n3;
            if ((this.buffer.hasData() || this.fragHint > 0) && (n3 = this.nextChunk(byteBuffer)) <= this.fragHint && (n2 = this.fragHint - this.buffer.length()) > 0) {
                int n4 = Math.min(n2, n3);
                int n5 = this.writeToBuffer(byteBuffer, n4);
                this.remaining -= (long)n5;
                n += n5;
            }
            if (this.buffer.hasData()) {
                n3 = this.nextChunk(byteBuffer);
                if ((this.buffer.length() >= this.fragHint || n3 > 0) && (n2 = this.flushToChannel()) == 0) break;
            }
            if (this.buffer.hasData() || (n3 = this.nextChunk(byteBuffer)) <= this.fragHint) continue;
            n2 = this.writeToChannel(byteBuffer, n3);
            this.remaining -= (long)n2;
            n += n2;
            if (n2 != 0) continue;
            break;
        }
        if (this.remaining <= 0L) {
            super.complete();
        }
        return n;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l, long l2) throws IOException {
        if (fileChannel == null) {
            return 0L;
        }
        this.assertNotCompleted();
        this.flushToChannel();
        if (this.buffer.hasData()) {
            return 0L;
        }
        long l3 = Math.min(this.remaining, l2);
        long l4 = fileChannel.transferTo(l, l3, this.channel);
        if (l4 > 0L) {
            this.metrics.incrementBytesTransferred(l4);
        }
        this.remaining -= l4;
        if (this.remaining <= 0L) {
            super.complete();
        }
        return l4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[content length: ");
        stringBuilder.append(this.contentLength);
        stringBuilder.append("; pos: ");
        stringBuilder.append(this.contentLength - this.remaining);
        stringBuilder.append("; completed: ");
        stringBuilder.append(this.isCompleted());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

