/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.icbc.api.internal.apache.http.pool.PoolEntry;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;

@Contract(threading=ThreadingBehavior.SAFE)
class CPoolEntry
extends PoolEntry<HttpRoute, ManagedNHttpClientConnection> {
    private final Log log;
    private volatile int socketTimeout;
    private volatile boolean routeComplete;

    public CPoolEntry(Log log, String string, HttpRoute httpRoute, ManagedNHttpClientConnection managedNHttpClientConnection, long l, TimeUnit timeUnit) {
        super(string, httpRoute, managedNHttpClientConnection, l, timeUnit);
        this.log = log;
    }

    public boolean isRouteComplete() {
        return this.routeComplete;
    }

    public void markRouteComplete() {
        this.routeComplete = true;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public void closeConnection() throws IOException {
        ManagedNHttpClientConnection managedNHttpClientConnection = (ManagedNHttpClientConnection)this.getConnection();
        managedNHttpClientConnection.close();
    }

    public void shutdownConnection() throws IOException {
        ManagedNHttpClientConnection managedNHttpClientConnection = (ManagedNHttpClientConnection)this.getConnection();
        managedNHttpClientConnection.shutdown();
    }

    @Override
    public boolean isExpired(long l) {
        boolean bl = super.isExpired(l);
        if (bl && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection " + this + " expired @ " + new Date(this.getExpiry())));
        }
        return bl;
    }

    @Override
    public boolean isClosed() {
        ManagedNHttpClientConnection managedNHttpClientConnection = (ManagedNHttpClientConnection)this.getConnection();
        return !managedNHttpClientConnection.isOpen();
    }

    @Override
    public void close() {
        try {
            this.closeConnection();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing connection", (Throwable)iOException);
        }
    }
}

