/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.HttpConnectionMetrics;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.impl.conn.ConnectionShutdownException;
import com.icbc.api.internal.apache.http.impl.nio.conn.CPoolEntry;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetAddress;
import javax.net.ssl.SSLSession;

class CPoolProxy
implements ManagedNHttpClientConnection {
    private volatile CPoolEntry poolEntry;

    CPoolProxy(CPoolEntry cPoolEntry) {
        this.poolEntry = cPoolEntry;
    }

    CPoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    CPoolEntry detach() {
        CPoolEntry cPoolEntry = this.poolEntry;
        this.poolEntry = null;
        return cPoolEntry;
    }

    ManagedNHttpClientConnection getConnection() {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry == null) {
            return null;
        }
        return (ManagedNHttpClientConnection)cPoolEntry.getConnection();
    }

    ManagedNHttpClientConnection getValidConnection() {
        ManagedNHttpClientConnection managedNHttpClientConnection = this.getConnection();
        if (managedNHttpClientConnection == null) {
            throw new ConnectionShutdownException();
        }
        return managedNHttpClientConnection;
    }

    @Override
    public void close() throws IOException {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            cPoolEntry.closeConnection();
        }
    }

    @Override
    public void shutdown() throws IOException {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            cPoolEntry.shutdownConnection();
        }
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.getValidConnection().getMetrics();
    }

    @Override
    public void requestInput() {
        ManagedNHttpClientConnection managedNHttpClientConnection = this.getConnection();
        if (managedNHttpClientConnection != null) {
            managedNHttpClientConnection.requestInput();
        }
    }

    @Override
    public void suspendInput() {
        ManagedNHttpClientConnection managedNHttpClientConnection = this.getConnection();
        if (managedNHttpClientConnection != null) {
            managedNHttpClientConnection.suspendInput();
        }
    }

    @Override
    public void requestOutput() {
        ManagedNHttpClientConnection managedNHttpClientConnection = this.getConnection();
        if (managedNHttpClientConnection != null) {
            managedNHttpClientConnection.requestOutput();
        }
    }

    @Override
    public void suspendOutput() {
        ManagedNHttpClientConnection managedNHttpClientConnection = this.getConnection();
        if (managedNHttpClientConnection != null) {
            managedNHttpClientConnection.suspendOutput();
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getValidConnection().getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getValidConnection().getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getValidConnection().getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getValidConnection().getRemotePort();
    }

    @Override
    public boolean isOpen() {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            return !cPoolEntry.isClosed();
        }
        return false;
    }

    @Override
    public boolean isStale() {
        ManagedNHttpClientConnection managedNHttpClientConnection = this.getConnection();
        if (managedNHttpClientConnection != null) {
            return !managedNHttpClientConnection.isOpen();
        }
        return false;
    }

    @Override
    public void setSocketTimeout(int n) {
        this.getValidConnection().setSocketTimeout(n);
    }

    @Override
    public int getSocketTimeout() {
        return this.getValidConnection().getSocketTimeout();
    }

    @Override
    public void submitRequest(HttpRequest httpRequest) throws IOException, HttpException {
        this.getValidConnection().submitRequest(httpRequest);
    }

    @Override
    public boolean isRequestSubmitted() {
        return this.getValidConnection().isRequestSubmitted();
    }

    @Override
    public void resetOutput() {
        this.getValidConnection().resetOutput();
    }

    @Override
    public void resetInput() {
        this.getValidConnection().resetInput();
    }

    @Override
    public int getStatus() {
        return this.getValidConnection().getStatus();
    }

    @Override
    public HttpRequest getHttpRequest() {
        return this.getValidConnection().getHttpRequest();
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.getValidConnection().getHttpResponse();
    }

    @Override
    public HttpContext getContext() {
        return this.getValidConnection().getContext();
    }

    public static NHttpClientConnection newProxy(CPoolEntry cPoolEntry) {
        return new CPoolProxy(cPoolEntry);
    }

    private static CPoolProxy getProxy(NHttpClientConnection nHttpClientConnection) {
        if (!CPoolProxy.class.isInstance(nHttpClientConnection)) {
            throw new IllegalStateException("Unexpected connection proxy class: " + nHttpClientConnection.getClass());
        }
        return (CPoolProxy)CPoolProxy.class.cast(nHttpClientConnection);
    }

    public static CPoolEntry getPoolEntry(NHttpClientConnection nHttpClientConnection) {
        CPoolEntry cPoolEntry = CPoolProxy.getProxy(nHttpClientConnection).getPoolEntry();
        if (cPoolEntry == null) {
            throw new ConnectionShutdownException();
        }
        return cPoolEntry;
    }

    public static CPoolEntry detach(NHttpClientConnection nHttpClientConnection) {
        return CPoolProxy.getProxy(nHttpClientConnection).detach();
    }

    @Override
    public String getId() {
        return this.getValidConnection().getId();
    }

    @Override
    public void bind(IOSession iOSession) {
        this.getValidConnection().bind(iOSession);
    }

    @Override
    public IOSession getIOSession() {
        return this.getValidConnection().getIOSession();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.getValidConnection().getSSLSession();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CPoolProxy{");
        ManagedNHttpClientConnection managedNHttpClientConnection = this.getConnection();
        if (managedNHttpClientConnection != null) {
            stringBuilder.append(managedNHttpClientConnection);
        } else {
            stringBuilder.append("detached");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

