/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.impl.nio.conn.Wire;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionBufferStatus;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.apache.commons.logging.Log;

class LoggingIOSession
implements IOSession {
    private final IOSession session;
    private final ByteChannel channel;
    private final String id;
    private final Log log;
    private final Wire wirelog;

    public LoggingIOSession(IOSession iOSession, String string, Log log, Log log2) {
        this.session = iOSession;
        this.channel = new LoggingByteChannel();
        this.id = string;
        this.log = log;
        this.wirelog = new Wire(log2, this.id);
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public int getEventMask() {
        return this.session.getEventMask();
    }

    private static String formatOps(int n) {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append('[');
        if ((n & 1) > 0) {
            stringBuilder.append('r');
        }
        if ((n & 4) > 0) {
            stringBuilder.append('w');
        }
        if ((n & 0x10) > 0) {
            stringBuilder.append('a');
        }
        if ((n & 8) > 0) {
            stringBuilder.append('c');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void setEventMask(int n) {
        this.session.setEventMask(n);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Event mask set " + LoggingIOSession.formatOps(n)));
        }
    }

    @Override
    public void setEvent(int n) {
        this.session.setEvent(n);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Event set " + LoggingIOSession.formatOps(n)));
        }
    }

    @Override
    public void clearEvent(int n) {
        this.session.clearEvent(n);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Event cleared " + LoggingIOSession.formatOps(n)));
        }
    }

    @Override
    public void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Close"));
        }
        this.session.close();
    }

    @Override
    public int getStatus() {
        return this.session.getStatus();
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public void shutdown() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Shutdown"));
        }
        this.session.shutdown();
    }

    @Override
    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Set timeout " + n));
        }
        this.session.setSocketTimeout(n);
    }

    @Override
    public void setBufferStatus(SessionBufferStatus sessionBufferStatus) {
        this.session.setBufferStatus(sessionBufferStatus);
    }

    @Override
    public boolean hasBufferedInput() {
        return this.session.hasBufferedInput();
    }

    @Override
    public boolean hasBufferedOutput() {
        return this.session.hasBufferedOutput();
    }

    @Override
    public Object getAttribute(String string) {
        return this.session.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Set attribute " + string));
        }
        this.session.setAttribute(string, object);
    }

    @Override
    public Object removeAttribute(String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " " + this.session + ": Remove attribute " + string));
        }
        return this.session.removeAttribute(string);
    }

    public String toString() {
        return this.id + " " + this.session.toString();
    }

    class LoggingByteChannel
    implements ByteChannel {
        LoggingByteChannel() {
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            int n = LoggingIOSession.this.session.channel().read(byteBuffer);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug((Object)(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + n + " bytes read"));
            }
            if (n > 0 && LoggingIOSession.this.wirelog.isEnabled()) {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                int n2 = byteBuffer2.position();
                byteBuffer2.limit(n2);
                byteBuffer2.position(n2 - n);
                LoggingIOSession.this.wirelog.input(byteBuffer2);
            }
            return n;
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            int n = LoggingIOSession.this.session.channel().write(byteBuffer);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug((Object)(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + n + " bytes written"));
            }
            if (n > 0 && LoggingIOSession.this.wirelog.isEnabled()) {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                int n2 = byteBuffer2.position();
                byteBuffer2.limit(n2);
                byteBuffer2.position(n2 - n);
                LoggingIOSession.this.wirelog.output(byteBuffer2);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug((Object)(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": Channel close"));
            }
            LoggingIOSession.this.session.channel().close();
        }

        @Override
        public boolean isOpen() {
            return LoggingIOSession.this.session.channel().isOpen();
        }
    }
}

