/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import com.icbc.api.internal.apache.http.impl.nio.conn.ManagedNHttpClientConnectionImpl;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedNHttpClientConnectionFactory
implements NHttpConnectionFactory<ManagedNHttpClientConnection> {
    private final Log headerlog = LogFactory.getLog((String)"org.apache.http.headers");
    private final Log wirelog = LogFactory.getLog((String)"org.apache.http.wire");
    private final Log log = LogFactory.getLog(ManagedNHttpClientConnectionImpl.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    public static final ManagedNHttpClientConnectionFactory INSTANCE = new ManagedNHttpClientConnectionFactory();
    private final ByteBufferAllocator allocator;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;

    public ManagedNHttpClientConnectionFactory(NHttpMessageWriterFactory<HttpRequest> defaultHttpRequestWriterFactory, NHttpMessageParserFactory<HttpResponse> defaultHttpResponseParserFactory, ByteBufferAllocator byteBufferAllocator) {
        this.requestWriterFactory = defaultHttpRequestWriterFactory != null ? defaultHttpRequestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.responseParserFactory = defaultHttpResponseParserFactory != null ? defaultHttpResponseParserFactory : DefaultHttpResponseParserFactory.INSTANCE;
        this.allocator = byteBufferAllocator != null ? byteBufferAllocator : HeapByteBufferAllocator.INSTANCE;
    }

    public ManagedNHttpClientConnectionFactory() {
        this(null, null, null);
    }

    @Override
    public ManagedNHttpClientConnection create(IOSession iOSession, ConnectionConfig connectionConfig) {
        CodingErrorAction codingErrorAction;
        String string = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
        CharsetDecoder charsetDecoder = null;
        CharsetEncoder charsetEncoder = null;
        Charset charset = connectionConfig.getCharset();
        CodingErrorAction codingErrorAction2 = connectionConfig.getMalformedInputAction() != null ? connectionConfig.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction3 = codingErrorAction = connectionConfig.getUnmappableInputAction() != null ? connectionConfig.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            charsetDecoder = charset.newDecoder();
            charsetDecoder.onMalformedInput(codingErrorAction2);
            charsetDecoder.onUnmappableCharacter(codingErrorAction);
            charsetEncoder = charset.newEncoder();
            charsetEncoder.onMalformedInput(codingErrorAction2);
            charsetEncoder.onUnmappableCharacter(codingErrorAction);
        }
        ManagedNHttpClientConnectionImpl managedNHttpClientConnectionImpl = new ManagedNHttpClientConnectionImpl(string, this.log, this.headerlog, this.wirelog, iOSession, connectionConfig.getBufferSize(), connectionConfig.getFragmentSizeHint(), this.allocator, charsetDecoder, charsetEncoder, connectionConfig.getMessageConstraints(), null, null, this.requestWriterFactory, this.responseParserFactory);
        iOSession.setAttribute("http.connection", managedNHttpClientConnectionImpl);
        return managedNHttpClientConnectionImpl;
    }
}

