/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.pool;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.pool.NIOConnFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> nHttpConnectionFactory, NHttpConnectionFactory<? extends NHttpClientConnection> nHttpConnectionFactory2) {
        Args.notNull(nHttpConnectionFactory, "Plain HTTP client connection factory");
        this.plainFactory = nHttpConnectionFactory;
        this.sslFactory = nHttpConnectionFactory2;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> nHttpConnectionFactory) {
        this(nHttpConnectionFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpResponseFactory httpResponseFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        this(new DefaultNHttpClientConnectionFactory(httpResponseFactory, byteBufferAllocator, httpParams), new SSLNHttpClientConnectionFactory(sSLContext, sSLSetupHandler, httpResponseFactory, byteBufferAllocator, httpParams));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpParams httpParams) {
        this(sSLContext, sSLSetupHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams httpParams) {
        this(null, null, httpParams);
    }

    public BasicNIOConnFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this(new DefaultNHttpClientConnectionFactory(nHttpMessageParserFactory, nHttpMessageWriterFactory, byteBufferAllocator, connectionConfig), new SSLNHttpClientConnectionFactory(sSLContext, sSLSetupHandler, nHttpMessageParserFactory, nHttpMessageWriterFactory, byteBufferAllocator, connectionConfig));
    }

    public BasicNIOConnFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, ConnectionConfig connectionConfig) {
        this(sSLContext, sSLSetupHandler, null, null, null, connectionConfig);
    }

    public BasicNIOConnFactory(ConnectionConfig connectionConfig) {
        this(new DefaultNHttpClientConnectionFactory(connectionConfig), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost httpHost, IOSession iOSession) throws IOException {
        NHttpClientConnection nHttpClientConnection;
        if (httpHost.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            nHttpClientConnection = this.sslFactory.createConnection(iOSession);
        } else {
            nHttpClientConnection = this.plainFactory.createConnection(iOSession);
        }
        iOSession.setAttribute("http.connection", nHttpClientConnection);
        return nHttpClientConnection;
    }
}

