/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.pool;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.impl.nio.pool.BasicNIOConnFactory;
import com.icbc.api.internal.apache.http.impl.nio.pool.BasicNIOPoolEntry;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.pool.AbstractNIOConnPool;
import com.icbc.api.internal.apache.http.nio.pool.NIOConnFactory;
import com.icbc.api.internal.apache.http.nio.pool.SocketAddressResolver;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicNIOConnPool
extends AbstractNIOConnPool<HttpHost, NHttpClientConnection, BasicNIOPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final int connectTimeout;

    @Deprecated
    public BasicNIOConnPool(ConnectingIOReactor connectingIOReactor, NIOConnFactory<HttpHost, NHttpClientConnection> nIOConnFactory, HttpParams httpParams) {
        super(connectingIOReactor, nIOConnFactory, 2, 20);
        Args.notNull(httpParams, "HTTP parameters");
        this.connectTimeout = httpParams.getIntParameter("http.connection.timeout", 0);
    }

    @Deprecated
    public BasicNIOConnPool(ConnectingIOReactor connectingIOReactor, HttpParams httpParams) {
        this(connectingIOReactor, (NIOConnFactory<HttpHost, NHttpClientConnection>)new BasicNIOConnFactory(httpParams), httpParams);
    }

    public BasicNIOConnPool(ConnectingIOReactor connectingIOReactor, NIOConnFactory<HttpHost, NHttpClientConnection> nIOConnFactory, int n) {
        super(connectingIOReactor, nIOConnFactory, new BasicAddressResolver(), 2, 20);
        this.connectTimeout = n;
    }

    public BasicNIOConnPool(ConnectingIOReactor connectingIOReactor, int n, ConnectionConfig connectionConfig) {
        this(connectingIOReactor, (NIOConnFactory<HttpHost, NHttpClientConnection>)new BasicNIOConnFactory(connectionConfig), n);
    }

    public BasicNIOConnPool(ConnectingIOReactor connectingIOReactor, ConnectionConfig connectionConfig) {
        this(connectingIOReactor, (NIOConnFactory<HttpHost, NHttpClientConnection>)new BasicNIOConnFactory(connectionConfig), 0);
    }

    public BasicNIOConnPool(ConnectingIOReactor connectingIOReactor) {
        this(connectingIOReactor, (NIOConnFactory<HttpHost, NHttpClientConnection>)new BasicNIOConnFactory(ConnectionConfig.DEFAULT), 0);
    }

    @Override
    @Deprecated
    protected SocketAddress resolveRemoteAddress(HttpHost httpHost) {
        return new InetSocketAddress(httpHost.getHostName(), httpHost.getPort());
    }

    @Override
    @Deprecated
    protected SocketAddress resolveLocalAddress(HttpHost httpHost) {
        return null;
    }

    @Override
    protected BasicNIOPoolEntry createEntry(HttpHost httpHost, NHttpClientConnection nHttpClientConnection) {
        BasicNIOPoolEntry basicNIOPoolEntry = new BasicNIOPoolEntry(Long.toString(COUNTER.getAndIncrement()), httpHost, nHttpClientConnection);
        basicNIOPoolEntry.setSocketTimeout(nHttpClientConnection.getSocketTimeout());
        return basicNIOPoolEntry;
    }

    @Override
    public Future<BasicNIOPoolEntry> lease(HttpHost httpHost, Object object, FutureCallback<BasicNIOPoolEntry> futureCallback) {
        return super.lease(httpHost, object, this.connectTimeout, TimeUnit.MILLISECONDS, futureCallback);
    }

    @Override
    public Future<BasicNIOPoolEntry> lease(HttpHost httpHost, Object object) {
        return super.lease(httpHost, object, this.connectTimeout, TimeUnit.MILLISECONDS, null);
    }

    @Override
    protected void onLease(BasicNIOPoolEntry basicNIOPoolEntry) {
        NHttpClientConnection nHttpClientConnection = (NHttpClientConnection)basicNIOPoolEntry.getConnection();
        nHttpClientConnection.setSocketTimeout(basicNIOPoolEntry.getSocketTimeout());
    }

    @Override
    protected void onRelease(BasicNIOPoolEntry basicNIOPoolEntry) {
        NHttpClientConnection nHttpClientConnection = (NHttpClientConnection)basicNIOPoolEntry.getConnection();
        basicNIOPoolEntry.setSocketTimeout(nHttpClientConnection.getSocketTimeout());
        nHttpClientConnection.setSocketTimeout(0);
    }

    static class BasicAddressResolver
    implements SocketAddressResolver<HttpHost> {
        BasicAddressResolver() {
        }

        @Override
        public SocketAddress resolveLocalAddress(HttpHost httpHost) {
            return null;
        }

        @Override
        public SocketAddress resolveRemoteAddress(HttpHost httpHost) {
            String string = httpHost.getHostName();
            int n = httpHost.getPort();
            if (n == -1) {
                if (httpHost.getSchemeName().equalsIgnoreCase("http")) {
                    n = 80;
                } else if (httpHost.getSchemeName().equalsIgnoreCase("https")) {
                    n = 443;
                }
            }
            return new InetSocketAddress(string, n);
        }
    }
}

