/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.impl.nio.reactor.ChannelEntry;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOSessionImpl;
import com.icbc.api.internal.apache.http.impl.nio.reactor.InterestOpEntry;
import com.icbc.api.internal.apache.http.impl.nio.reactor.InterestOpsCallback;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SessionClosedCallback;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SessionRequestImpl;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorStatus;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AbstractIOReactor
implements IOReactor {
    private volatile IOReactorStatus status;
    private final Object statusMutex;
    private final long selectTimeout;
    private final boolean interestOpsQueueing;
    private final Selector selector;
    private final Set<IOSession> sessions;
    private final Queue<InterestOpEntry> interestOpsQueue;
    private final Queue<IOSession> closedSessions;
    private final Queue<ChannelEntry> newChannels;

    public AbstractIOReactor(long l) throws IOReactorException {
        this(l, false);
    }

    public AbstractIOReactor(long l, boolean bl) throws IOReactorException {
        Args.positive(l, "Select timeout");
        this.selectTimeout = l;
        this.interestOpsQueueing = bl;
        this.sessions = Collections.synchronizedSet(new HashSet());
        this.interestOpsQueue = new ConcurrentLinkedQueue<InterestOpEntry>();
        this.closedSessions = new ConcurrentLinkedQueue<IOSession>();
        this.newChannels = new ConcurrentLinkedQueue<ChannelEntry>();
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new IOReactorException("Failure opening selector", iOException);
        }
        this.statusMutex = new Object();
        this.status = IOReactorStatus.INACTIVE;
    }

    protected abstract void acceptable(SelectionKey var1);

    protected abstract void connectable(SelectionKey var1);

    protected abstract void readable(SelectionKey var1);

    protected abstract void writable(SelectionKey var1);

    protected abstract void validate(Set<SelectionKey> var1);

    protected void sessionCreated(SelectionKey selectionKey, IOSession iOSession) {
    }

    protected void sessionClosed(IOSession iOSession) {
    }

    protected void sessionTimedOut(IOSession iOSession) {
    }

    protected IOSession getSession(SelectionKey selectionKey) {
        return (IOSession)selectionKey.attachment();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status;
    }

    public boolean getInterestOpsQueueing() {
        return this.interestOpsQueueing;
    }

    public void addChannel(ChannelEntry channelEntry) {
        Args.notNull(channelEntry, "Channel entry");
        this.newChannels.add(channelEntry);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws InterruptedIOException, IOReactorException {
        this.status = IOReactorStatus.ACTIVE;
        try {
            while (true) {
                int n;
                try {
                    n = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw interruptedIOException;
                }
                catch (IOException iOException) {
                    throw new IOReactorException("Unexpected selector failure", iOException);
                }
                if (this.status == IOReactorStatus.SHUT_DOWN) {
                    break;
                }
                if (this.status == IOReactorStatus.SHUTTING_DOWN) {
                    this.closeSessions();
                    this.closeNewChannels();
                }
                if (n > 0) {
                    this.processEvents(this.selector.selectedKeys());
                }
                this.validate(this.selector.keys());
                this.processClosedSessions();
                if (this.status == IOReactorStatus.ACTIVE) {
                    this.processNewChannels();
                }
                if (this.status.compareTo(IOReactorStatus.ACTIVE) > 0 && this.sessions.isEmpty()) {
                    break;
                }
                if (!this.interestOpsQueueing) continue;
                this.processPendingInterestOps();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            this.hardShutdown();
            Object object = this.statusMutex;
            synchronized (object) {
                this.statusMutex.notifyAll();
            }
        }
        finally {
            this.hardShutdown();
            Object object = this.statusMutex;
            synchronized (object) {
                this.statusMutex.notifyAll();
            }
        }
    }

    private void processEvents(Set<SelectionKey> set) {
        for (SelectionKey selectionKey : set) {
            this.processEvent(selectionKey);
        }
        set.clear();
    }

    protected void processEvent(SelectionKey selectionKey) {
        IOSessionImpl iOSessionImpl = (IOSessionImpl)selectionKey.attachment();
        try {
            if (selectionKey.isAcceptable()) {
                this.acceptable(selectionKey);
            }
            if (selectionKey.isConnectable()) {
                this.connectable(selectionKey);
            }
            if (selectionKey.isReadable()) {
                iOSessionImpl.resetLastRead();
                this.readable(selectionKey);
            }
            if (selectionKey.isWritable()) {
                iOSessionImpl.resetLastWrite();
                this.writable(selectionKey);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.queueClosedSession(iOSessionImpl);
            selectionKey.attach(null);
        }
    }

    protected void queueClosedSession(IOSession iOSession) {
        if (iOSession != null) {
            this.closedSessions.add(iOSession);
        }
    }

    private void processNewChannels() throws IOReactorException {
        ChannelEntry channelEntry;
        while ((channelEntry = this.newChannels.poll()) != null) {
            IOSessionImpl iOSessionImpl;
            Object object;
            SelectionKey selectionKey;
            SocketChannel socketChannel;
            try {
                socketChannel = channelEntry.getChannel();
                socketChannel.configureBlocking(false);
                selectionKey = socketChannel.register(this.selector, 1);
            }
            catch (ClosedChannelException closedChannelException) {
                object = channelEntry.getSessionRequest();
                if (object != null) {
                    ((SessionRequestImpl)object).failed(closedChannelException);
                }
                return;
            }
            catch (IOException iOException) {
                throw new IOReactorException("Failure registering channel with the selector", iOException);
            }
            SessionClosedCallback sessionClosedCallback = new SessionClosedCallback(){

                @Override
                public void sessionClosed(IOSession iOSession) {
                    AbstractIOReactor.this.queueClosedSession(iOSession);
                }
            };
            object = null;
            if (this.interestOpsQueueing) {
                object = new InterestOpsCallback(){

                    @Override
                    public void addInterestOps(InterestOpEntry interestOpEntry) {
                        AbstractIOReactor.this.queueInterestOps(interestOpEntry);
                    }
                };
            }
            try {
                iOSessionImpl = new IOSessionImpl(selectionKey, (InterestOpsCallback)object, sessionClosedCallback);
                int n = 0;
                try {
                    n = socketChannel.socket().getSoTimeout();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                iOSessionImpl.setAttribute("http.session.attachment", channelEntry.getAttachment());
                iOSessionImpl.setSocketTimeout(n);
            }
            catch (CancelledKeyException cancelledKeyException) {
                continue;
            }
            try {
                this.sessions.add(iOSessionImpl);
                SessionRequestImpl sessionRequestImpl = channelEntry.getSessionRequest();
                if (sessionRequestImpl != null) {
                    sessionRequestImpl.completed(iOSessionImpl);
                }
                selectionKey.attach(iOSessionImpl);
                this.sessionCreated(selectionKey, iOSessionImpl);
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.queueClosedSession(iOSessionImpl);
                selectionKey.attach(null);
            }
        }
    }

    private void processClosedSessions() {
        IOSession iOSession;
        while ((iOSession = this.closedSessions.poll()) != null) {
            if (!this.sessions.remove(iOSession)) continue;
            try {
                this.sessionClosed(iOSession);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void processPendingInterestOps() {
        InterestOpEntry interestOpEntry;
        if (!this.interestOpsQueueing) {
            return;
        }
        while ((interestOpEntry = this.interestOpsQueue.poll()) != null) {
            SelectionKey selectionKey = interestOpEntry.getSelectionKey();
            int n = interestOpEntry.getEventMask();
            if (!selectionKey.isValid()) continue;
            selectionKey.interestOps(n);
        }
    }

    private boolean queueInterestOps(InterestOpEntry interestOpEntry) {
        Asserts.check(this.interestOpsQueueing, "Interest ops queueing not enabled");
        if (interestOpEntry == null) {
            return false;
        }
        this.interestOpsQueue.add(interestOpEntry);
        return true;
    }

    protected void timeoutCheck(SelectionKey selectionKey, long l) {
        int n;
        IOSessionImpl iOSessionImpl = (IOSessionImpl)selectionKey.attachment();
        if (iOSessionImpl != null && (n = iOSessionImpl.getSocketTimeout()) > 0 && iOSessionImpl.getLastAccessTime() + (long)n < l) {
            this.sessionTimedOut(iOSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSessions() {
        Set<IOSession> set = this.sessions;
        synchronized (set) {
            for (IOSession iOSession : this.sessions) {
                iOSession.close();
            }
        }
    }

    protected void closeNewChannels() throws IOReactorException {
        ChannelEntry channelEntry;
        while ((channelEntry = this.newChannels.poll()) != null) {
            SessionRequestImpl sessionRequestImpl = channelEntry.getSessionRequest();
            if (sessionRequestImpl != null) {
                sessionRequestImpl.cancel();
            }
            SocketChannel socketChannel = channelEntry.getChannel();
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void closeActiveChannels() throws IOReactorException {
        try {
            Set<SelectionKey> set = this.selector.keys();
            for (SelectionKey selectionKey : set) {
                IOSession iOSession = this.getSession(selectionKey);
                if (iOSession == null) continue;
                iOSession.close();
            }
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulShutdown() {
        Object object = this.statusMutex;
        synchronized (object) {
            if (this.status != IOReactorStatus.ACTIVE) {
                return;
            }
            this.status = IOReactorStatus.SHUTTING_DOWN;
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardShutdown() throws IOReactorException {
        Object object = this.statusMutex;
        synchronized (object) {
            if (this.status == IOReactorStatus.SHUT_DOWN) {
                return;
            }
            this.status = IOReactorStatus.SHUT_DOWN;
        }
        this.closeNewChannels();
        this.closeActiveChannels();
        this.processClosedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown(long l) throws InterruptedException {
        Object object = this.statusMutex;
        synchronized (object) {
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (this.status != IOReactorStatus.SHUT_DOWN) {
                this.statusMutex.wait(l3);
                if (l <= 0L || (l3 = l2 - System.currentTimeMillis()) > 0L) continue;
            }
        }
    }

    @Override
    public void shutdown(long l) throws IOReactorException {
        if (this.status != IOReactorStatus.INACTIVE) {
            this.gracefulShutdown();
            try {
                this.awaitShutdown(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.status != IOReactorStatus.SHUT_DOWN) {
            this.hardShutdown();
        }
    }

    @Override
    public void shutdown() throws IOReactorException {
        this.shutdown(1000L);
    }
}

