/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.impl.nio.reactor.AbstractIOReactor;
import com.icbc.api.internal.apache.http.impl.nio.reactor.BaseIOReactor;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ChannelEntry;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ExceptionEvent;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.nio.reactor.IOEventDispatch;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorExceptionHandler;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorStatus;
import com.icbc.api.internal.apache.http.params.BasicHttpParams;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractMultiworkerIOReactor
implements IOReactor {
    protected volatile IOReactorStatus status;
    @Deprecated
    protected final HttpParams params;
    protected final IOReactorConfig config;
    protected final Selector selector;
    protected final long selectTimeout;
    protected final boolean interestOpsQueueing;
    private final int workerCount;
    private final ThreadFactory threadFactory;
    private final BaseIOReactor[] dispatchers;
    private final Worker[] workers;
    private final Thread[] threads;
    private final Object statusLock;
    protected IOReactorExceptionHandler exceptionHandler;
    protected List<ExceptionEvent> auditLog;
    private int currentWorker = 0;

    public AbstractMultiworkerIOReactor(IOReactorConfig iOReactorConfig, ThreadFactory threadFactory) throws IOReactorException {
        this.config = iOReactorConfig != null ? iOReactorConfig : IOReactorConfig.DEFAULT;
        this.params = new BasicHttpParams();
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new IOReactorException("Failure opening selector", iOException);
        }
        this.selectTimeout = this.config.getSelectInterval();
        this.interestOpsQueueing = this.config.isInterestOpQueued();
        this.statusLock = new Object();
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
        this.auditLog = new ArrayList<ExceptionEvent>();
        this.workerCount = this.config.getIoThreadCount();
        this.dispatchers = new BaseIOReactor[this.workerCount];
        this.workers = new Worker[this.workerCount];
        this.threads = new Thread[this.workerCount];
        this.status = IOReactorStatus.INACTIVE;
    }

    public AbstractMultiworkerIOReactor() throws IOReactorException {
        this(null, null);
    }

    @Deprecated
    static IOReactorConfig convert(int n, HttpParams httpParams) {
        Args.notNull(httpParams, "HTTP parameters");
        return IOReactorConfig.custom().setSelectInterval(httpParams.getLongParameter("http.nio.select-interval", 1000L)).setShutdownGracePeriod(httpParams.getLongParameter("http.nio.grace-period", 500L)).setInterestOpQueued(httpParams.getBooleanParameter("http.nio.select-interval", false)).setIoThreadCount(n).setSoTimeout(httpParams.getIntParameter("http.socket.timeout", 0)).setConnectTimeout(httpParams.getIntParameter("http.connection.timeout", 0)).setSoTimeout(httpParams.getIntParameter("http.socket.timeout", 0)).setSoReuseAddress(httpParams.getBooleanParameter("http.socket.reuseaddr", false)).setSoKeepAlive(httpParams.getBooleanParameter("http.socket.keepalive", false)).setSoLinger(httpParams.getIntParameter("http.socket.linger", -1)).setTcpNoDelay(httpParams.getBooleanParameter("http.tcp.nodelay", true)).build();
    }

    @Deprecated
    public AbstractMultiworkerIOReactor(int n, ThreadFactory threadFactory, HttpParams httpParams) throws IOReactorException {
        this(AbstractMultiworkerIOReactor.convert(n, httpParams), threadFactory);
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExceptionEvent> getAuditLog() {
        List<ExceptionEvent> list = this.auditLog;
        synchronized (list) {
            return new ArrayList<ExceptionEvent>(this.auditLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addExceptionEvent(Throwable throwable, Date date) {
        if (throwable == null) {
            return;
        }
        List<ExceptionEvent> list = this.auditLog;
        synchronized (list) {
            this.auditLog.add(new ExceptionEvent(throwable, date != null ? date : new Date()));
        }
    }

    protected void addExceptionEvent(Throwable throwable) {
        this.addExceptionEvent(throwable, null);
    }

    public void setExceptionHandler(IOReactorExceptionHandler iOReactorExceptionHandler) {
        this.exceptionHandler = iOReactorExceptionHandler;
    }

    protected abstract void processEvents(int var1) throws IOReactorException;

    protected abstract void cancelRequests() throws IOReactorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IOEventDispatch iOEventDispatch) throws InterruptedIOException, IOReactorException {
        Object object;
        int n;
        Args.notNull(iOEventDispatch, "Event dispatcher");
        Object object2 = this.statusLock;
        synchronized (object2) {
            if (this.status.compareTo(IOReactorStatus.SHUTDOWN_REQUEST) >= 0) {
                this.status = IOReactorStatus.SHUT_DOWN;
                this.statusLock.notifyAll();
                return;
            }
            Asserts.check(this.status.compareTo(IOReactorStatus.INACTIVE) == 0, "Illegal state %s", (Object)this.status);
            this.status = IOReactorStatus.ACTIVE;
            for (n = 0; n < this.dispatchers.length; ++n) {
                object = new BaseIOReactor(this.selectTimeout, this.interestOpsQueueing);
                ((BaseIOReactor)object).setExceptionHandler(this.exceptionHandler);
                this.dispatchers[n] = object;
            }
            for (n = 0; n < this.workerCount; ++n) {
                object = this.dispatchers[n];
                this.workers[n] = new Worker((BaseIOReactor)object, iOEventDispatch);
                this.threads[n] = this.threadFactory.newThread(this.workers[n]);
            }
        }
        try {
            int n2;
            for (n2 = 0; n2 < this.workerCount; ++n2) {
                if (this.status != IOReactorStatus.ACTIVE) {
                    return;
                }
                this.threads[n2].start();
            }
            do {
                try {
                    n2 = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw interruptedIOException;
                }
                catch (IOException iOException) {
                    throw new IOReactorException("Unexpected selector failure", iOException);
                }
                if (this.status.compareTo(IOReactorStatus.ACTIVE) == 0) {
                    this.processEvents(n2);
                }
                for (n = 0; n < this.workerCount; ++n) {
                    object = this.workers[n];
                    Exception exception = ((Worker)object).getException();
                    if (exception == null) continue;
                    throw new IOReactorException("I/O dispatch worker terminated abnormally", exception);
                }
            } while (this.status.compareTo(IOReactorStatus.ACTIVE) <= 0);
        }
        catch (ClosedSelectorException closedSelectorException) {
            this.addExceptionEvent(closedSelectorException);
        }
        catch (IOReactorException iOReactorException) {
            if (iOReactorException.getCause() != null) {
                this.addExceptionEvent(iOReactorException.getCause());
            }
            throw iOReactorException;
        }
        finally {
            this.doShutdown();
            Object object3 = this.statusLock;
            synchronized (object3) {
                this.status = IOReactorStatus.SHUT_DOWN;
                this.statusLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdown() throws InterruptedIOException {
        block20: {
            Iterator<SelectionKey> iterator = this.statusLock;
            synchronized (iterator) {
                if (this.status.compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
                    return;
                }
                this.status = IOReactorStatus.SHUTTING_DOWN;
            }
            try {
                this.cancelRequests();
            }
            catch (IOReactorException iOReactorException) {
                if (iOReactorException.getCause() == null) break block20;
                this.addExceptionEvent(iOReactorException.getCause());
            }
        }
        this.selector.wakeup();
        if (this.selector.isOpen()) {
            for (SelectionKey object : this.selector.keys()) {
                try {
                    SelectableChannel n = object.channel();
                    if (n == null) continue;
                    n.close();
                }
                catch (IOException interruptedException) {
                    this.addExceptionEvent(interruptedException);
                }
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                this.addExceptionEvent(iOException);
            }
        }
        for (int i = 0; i < this.workerCount; ++i) {
            BaseIOReactor baseIOReactor = this.dispatchers[i];
            baseIOReactor.gracefulShutdown();
        }
        long l = this.config.getShutdownGracePeriod();
        try {
            Object object;
            int n;
            for (n = 0; n < this.workerCount; ++n) {
                object = this.dispatchers[n];
                if (((AbstractIOReactor)object).getStatus() != IOReactorStatus.INACTIVE) {
                    ((AbstractIOReactor)object).awaitShutdown(l);
                }
                if (((AbstractIOReactor)object).getStatus() == IOReactorStatus.SHUT_DOWN) continue;
                try {
                    ((AbstractIOReactor)object).hardShutdown();
                    continue;
                }
                catch (IOReactorException iOReactorException) {
                    if (iOReactorException.getCause() == null) continue;
                    this.addExceptionEvent(iOReactorException.getCause());
                }
            }
            for (n = 0; n < this.workerCount; ++n) {
                object = this.threads[n];
                if (object == null) continue;
                ((Thread)object).join(l);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException(interruptedException.getMessage());
        }
    }

    protected void addChannel(ChannelEntry channelEntry) {
        int n = Math.abs(this.currentWorker++ % this.workerCount);
        this.dispatchers[n].addChannel(channelEntry);
    }

    protected SelectionKey registerChannel(SelectableChannel selectableChannel, int n) throws ClosedChannelException {
        return selectableChannel.register(this.selector, n);
    }

    protected void prepareSocket(Socket socket) throws IOException {
        int n;
        socket.setTcpNoDelay(this.config.isTcpNoDelay());
        socket.setKeepAlive(this.config.isSoKeepalive());
        if (this.config.getSoTimeout() > 0) {
            socket.setSoTimeout(this.config.getSoTimeout());
        }
        if (this.config.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.config.getSndBufSize());
        }
        if (this.config.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.config.getRcvBufSize());
        }
        if ((n = this.config.getSoLinger()) >= 0) {
            socket.setSoLinger(true, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitShutdown(long l) throws InterruptedException {
        Object object = this.statusLock;
        synchronized (object) {
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (this.status != IOReactorStatus.SHUT_DOWN) {
                this.statusLock.wait(l3);
                if (l <= 0L || (l3 = l2 - System.currentTimeMillis()) > 0L) continue;
            }
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(long l) throws IOException {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status.compareTo(IOReactorStatus.ACTIVE) > 0) {
                return;
            }
            if (this.status.compareTo(IOReactorStatus.INACTIVE) == 0) {
                this.status = IOReactorStatus.SHUT_DOWN;
                this.cancelRequests();
                this.selector.close();
                return;
            }
            this.status = IOReactorStatus.SHUTDOWN_REQUEST;
        }
        this.selector.wakeup();
        try {
            this.awaitShutdown(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void closeChannel(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicLong COUNT = new AtomicLong(1L);

        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "I/O dispatcher " + COUNT.getAndIncrement());
        }
    }

    static class Worker
    implements Runnable {
        final BaseIOReactor dispatcher;
        final IOEventDispatch eventDispatch;
        private volatile Exception exception;

        public Worker(BaseIOReactor baseIOReactor, IOEventDispatch iOEventDispatch) {
            this.dispatcher = baseIOReactor;
            this.eventDispatch = iOEventDispatch;
        }

        @Override
        public void run() {
            try {
                this.dispatcher.execute(this.eventDispatch);
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

