/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ChannelEntry;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SessionRequestHandle;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SessionRequestImpl;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorStatus;
import com.icbc.api.internal.apache.http.nio.reactor.SessionRequest;
import com.icbc.api.internal.apache.http.nio.reactor.SessionRequestCallback;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;

public class DefaultConnectingIOReactor
extends AbstractMultiworkerIOReactor
implements ConnectingIOReactor {
    private final Queue<SessionRequestImpl> requestQueue = new ConcurrentLinkedQueue<SessionRequestImpl>();
    private long lastTimeoutCheck = System.currentTimeMillis();

    public DefaultConnectingIOReactor(IOReactorConfig iOReactorConfig, ThreadFactory threadFactory) throws IOReactorException {
        super(iOReactorConfig, threadFactory);
    }

    public DefaultConnectingIOReactor(IOReactorConfig iOReactorConfig) throws IOReactorException {
        this(iOReactorConfig, null);
    }

    public DefaultConnectingIOReactor() throws IOReactorException {
        this(null, null);
    }

    @Deprecated
    public DefaultConnectingIOReactor(int n, ThreadFactory threadFactory, HttpParams httpParams) throws IOReactorException {
        this(DefaultConnectingIOReactor.convert(n, httpParams), threadFactory);
    }

    @Deprecated
    public DefaultConnectingIOReactor(int n, HttpParams httpParams) throws IOReactorException {
        this(DefaultConnectingIOReactor.convert(n, httpParams), null);
    }

    @Override
    protected void cancelRequests() throws IOReactorException {
        SessionRequestImpl sessionRequestImpl;
        while ((sessionRequestImpl = this.requestQueue.poll()) != null) {
            sessionRequestImpl.cancel();
        }
    }

    @Override
    protected void processEvents(int n) throws IOReactorException {
        long l;
        this.processSessionRequests();
        if (n > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            for (SelectionKey object : set) {
                this.processEvent(object);
            }
            set.clear();
        }
        if ((l = System.currentTimeMillis()) - this.lastTimeoutCheck >= this.selectTimeout) {
            this.lastTimeoutCheck = l;
            Set<SelectionKey> set = this.selector.keys();
            this.processTimeouts(set);
        }
    }

    private void processEvent(SelectionKey selectionKey) {
        block8: {
            try {
                if (!selectionKey.isConnectable()) break block8;
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                SessionRequestHandle sessionRequestHandle = (SessionRequestHandle)selectionKey.attachment();
                SessionRequestImpl sessionRequestImpl = sessionRequestHandle.getSessionRequest();
                try {
                    socketChannel.finishConnect();
                }
                catch (IOException iOException) {
                    sessionRequestImpl.failed(iOException);
                }
                selectionKey.cancel();
                selectionKey.attach(null);
                if (!sessionRequestImpl.isCompleted()) {
                    this.addChannel(new ChannelEntry(socketChannel, sessionRequestImpl));
                } else {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                SessionRequestImpl sessionRequestImpl;
                SessionRequestHandle sessionRequestHandle = (SessionRequestHandle)selectionKey.attachment();
                selectionKey.attach(null);
                if (sessionRequestHandle == null || (sessionRequestImpl = sessionRequestHandle.getSessionRequest()) == null) break block8;
                sessionRequestImpl.cancel();
            }
        }
    }

    private void processTimeouts(Set<SelectionKey> set) {
        long l = System.currentTimeMillis();
        for (SelectionKey selectionKey : set) {
            SessionRequestHandle sessionRequestHandle;
            SessionRequestImpl sessionRequestImpl;
            int n;
            Object object = selectionKey.attachment();
            if (!(object instanceof SessionRequestHandle) || (n = (sessionRequestImpl = (sessionRequestHandle = (SessionRequestHandle)selectionKey.attachment()).getSessionRequest()).getConnectTimeout()) <= 0 || sessionRequestHandle.getRequestTime() + (long)n >= l) continue;
            sessionRequestImpl.timeout();
        }
    }

    @Override
    public SessionRequest connect(SocketAddress socketAddress, SocketAddress socketAddress2, Object object, SessionRequestCallback sessionRequestCallback) {
        Asserts.check(this.status.compareTo(IOReactorStatus.ACTIVE) <= 0, "I/O reactor has been shut down");
        SessionRequestImpl sessionRequestImpl = new SessionRequestImpl(socketAddress, socketAddress2, object, sessionRequestCallback);
        sessionRequestImpl.setConnectTimeout(this.config.getConnectTimeout());
        this.requestQueue.add(sessionRequestImpl);
        this.selector.wakeup();
        return sessionRequestImpl;
    }

    private void validateAddress(SocketAddress socketAddress) throws UnknownHostException {
        InetSocketAddress inetSocketAddress;
        if (socketAddress == null) {
            return;
        }
        if (socketAddress instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)socketAddress).isUnresolved()) {
            throw new UnknownHostException(inetSocketAddress.getHostName());
        }
    }

    private void processSessionRequests() throws IOReactorException {
        SessionRequestImpl sessionRequestImpl;
        while ((sessionRequestImpl = this.requestQueue.poll()) != null) {
            Object object;
            SocketChannel socketChannel;
            if (sessionRequestImpl.isCompleted()) continue;
            try {
                socketChannel = SocketChannel.open();
            }
            catch (IOException iOException) {
                sessionRequestImpl.failed(iOException);
                return;
            }
            try {
                boolean bl;
                this.validateAddress(sessionRequestImpl.getLocalAddress());
                this.validateAddress(sessionRequestImpl.getRemoteAddress());
                socketChannel.configureBlocking(false);
                this.prepareSocket(socketChannel.socket());
                if (sessionRequestImpl.getLocalAddress() != null) {
                    Socket socket = socketChannel.socket();
                    socket.setReuseAddress(this.config.isSoReuseAddress());
                    socket.bind(sessionRequestImpl.getLocalAddress());
                }
                if (bl = socketChannel.connect(sessionRequestImpl.getRemoteAddress())) {
                    object = new ChannelEntry(socketChannel, sessionRequestImpl);
                    this.addChannel((ChannelEntry)object);
                    continue;
                }
            }
            catch (IOException iOException) {
                DefaultConnectingIOReactor.closeChannel(socketChannel);
                sessionRequestImpl.failed(iOException);
                return;
            }
            SessionRequestHandle sessionRequestHandle = new SessionRequestHandle(sessionRequestImpl);
            try {
                object = socketChannel.register(this.selector, 8, sessionRequestHandle);
                sessionRequestImpl.setKey((SelectionKey)object);
            }
            catch (IOException iOException) {
                DefaultConnectingIOReactor.closeChannel(socketChannel);
                throw new IOReactorException("Failure registering channel with the selector", iOException);
            }
        }
    }
}

