/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.impl.nio.reactor.InterestOpEntry;
import com.icbc.api.internal.apache.http.impl.nio.reactor.InterestOpsCallback;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SessionClosedCallback;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionBufferStatus;
import com.icbc.api.internal.apache.http.nio.reactor.SocketAccessor;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Contract(threading=ThreadingBehavior.SAFE)
public class IOSessionImpl
implements IOSession,
SocketAccessor {
    private final SelectionKey key;
    private final ByteChannel channel;
    private final Map<String, Object> attributes;
    private final InterestOpsCallback interestOpsCallback;
    private final SessionClosedCallback sessionClosedCallback;
    private volatile int status;
    private volatile int currentEventMask;
    private volatile SessionBufferStatus bufferStatus;
    private volatile int socketTimeout;
    private final long startedTime;
    private volatile long lastReadTime;
    private volatile long lastWriteTime;
    private volatile long lastAccessTime;

    public IOSessionImpl(SelectionKey selectionKey, InterestOpsCallback interestOpsCallback, SessionClosedCallback sessionClosedCallback) {
        long l;
        Args.notNull(selectionKey, "Selection key");
        this.key = selectionKey;
        this.channel = (ByteChannel)((Object)this.key.channel());
        this.interestOpsCallback = interestOpsCallback;
        this.sessionClosedCallback = sessionClosedCallback;
        this.attributes = Collections.synchronizedMap(new HashMap());
        this.currentEventMask = selectionKey.interestOps();
        this.socketTimeout = 0;
        this.status = 0;
        this.startedTime = l = System.currentTimeMillis();
        this.lastReadTime = l;
        this.lastWriteTime = l;
        this.lastAccessTime = l;
    }

    public IOSessionImpl(SelectionKey selectionKey, SessionClosedCallback sessionClosedCallback) {
        this(selectionKey, null, sessionClosedCallback);
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        if (this.channel instanceof SocketChannel) {
            return ((SocketChannel)this.channel).socket().getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        if (this.channel instanceof SocketChannel) {
            return ((SocketChannel)this.channel).socket().getRemoteSocketAddress();
        }
        return null;
    }

    @Override
    public int getEventMask() {
        return this.interestOpsCallback != null ? this.currentEventMask : this.key.interestOps();
    }

    @Override
    public synchronized void setEventMask(int n) {
        if (this.status == Integer.MAX_VALUE) {
            return;
        }
        if (this.interestOpsCallback != null) {
            this.currentEventMask = n;
            InterestOpEntry interestOpEntry = new InterestOpEntry(this.key, this.currentEventMask);
            this.interestOpsCallback.addInterestOps(interestOpEntry);
        } else {
            this.key.interestOps(n);
        }
        this.key.selector().wakeup();
    }

    @Override
    public synchronized void setEvent(int n) {
        if (this.status == Integer.MAX_VALUE) {
            return;
        }
        if (this.interestOpsCallback != null) {
            this.currentEventMask |= n;
            InterestOpEntry interestOpEntry = new InterestOpEntry(this.key, this.currentEventMask);
            this.interestOpsCallback.addInterestOps(interestOpEntry);
        } else {
            int n2 = this.key.interestOps();
            this.key.interestOps(n2 | n);
        }
        this.key.selector().wakeup();
    }

    @Override
    public synchronized void clearEvent(int n) {
        if (this.status == Integer.MAX_VALUE) {
            return;
        }
        if (this.interestOpsCallback != null) {
            this.currentEventMask &= ~n;
            InterestOpEntry interestOpEntry = new InterestOpEntry(this.key, this.currentEventMask);
            this.interestOpsCallback.addInterestOps(interestOpEntry);
        } else {
            int n2 = this.key.interestOps();
            this.key.interestOps(n2 & ~n);
        }
        this.key.selector().wakeup();
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
        this.lastAccessTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this;
        synchronized (object) {
            if (this.status == Integer.MAX_VALUE) {
                return;
            }
            this.status = Integer.MAX_VALUE;
        }
        object = this.key;
        synchronized (object) {
            this.key.cancel();
            try {
                this.key.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.sessionClosedCallback != null) {
                this.sessionClosedCallback.sessionClosed(this);
            }
            if (this.key.selector().isOpen()) {
                this.key.selector().wakeup();
            }
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isClosed() {
        return this.status == Integer.MAX_VALUE;
    }

    @Override
    public void shutdown() {
        this.close();
    }

    @Override
    public boolean hasBufferedInput() {
        SessionBufferStatus sessionBufferStatus = this.bufferStatus;
        return sessionBufferStatus != null && sessionBufferStatus.hasBufferedInput();
    }

    @Override
    public boolean hasBufferedOutput() {
        SessionBufferStatus sessionBufferStatus = this.bufferStatus;
        return sessionBufferStatus != null && sessionBufferStatus.hasBufferedOutput();
    }

    @Override
    public void setBufferStatus(SessionBufferStatus sessionBufferStatus) {
        this.bufferStatus = sessionBufferStatus;
    }

    @Override
    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    void resetLastRead() {
        long l;
        this.lastReadTime = l = System.currentTimeMillis();
        this.lastAccessTime = l;
    }

    void resetLastWrite() {
        long l;
        this.lastWriteTime = l = System.currentTimeMillis();
        this.lastAccessTime = l;
    }

    private static void formatOps(StringBuilder stringBuilder, int n) {
        if ((n & 1) > 0) {
            stringBuilder.append('r');
        }
        if ((n & 4) > 0) {
            stringBuilder.append('w');
        }
        if ((n & 0x10) > 0) {
            stringBuilder.append('a');
        }
        if ((n & 8) > 0) {
            stringBuilder.append('c');
        }
    }

    private static void formatAddress(StringBuilder stringBuilder, SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            stringBuilder.append(inetSocketAddress.getAddress() != null ? inetSocketAddress.getAddress().getHostAddress() : inetSocketAddress.getAddress()).append(':').append(inetSocketAddress.getPort());
        } else {
            stringBuilder.append(socketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            SocketAddress socketAddress = this.getRemoteAddress();
            SocketAddress socketAddress2 = this.getLocalAddress();
            if (socketAddress != null && socketAddress2 != null) {
                IOSessionImpl.formatAddress(stringBuilder, socketAddress2);
                stringBuilder.append("<->");
                IOSessionImpl.formatAddress(stringBuilder, socketAddress);
            }
            stringBuilder.append('[');
            switch (this.status) {
                case 0: {
                    stringBuilder.append("ACTIVE");
                    break;
                }
                case 1: {
                    stringBuilder.append("CLOSING");
                    break;
                }
                case 0x7FFFFFFF: {
                    stringBuilder.append("CLOSED");
                }
            }
            stringBuilder.append("][");
            if (this.key.isValid()) {
                IOSessionImpl.formatOps(stringBuilder, this.interestOpsCallback != null ? this.currentEventMask : this.key.interestOps());
                stringBuilder.append(':');
                IOSessionImpl.formatOps(stringBuilder, this.key.readyOps());
            }
        }
        stringBuilder.append(']');
        return new String(stringBuilder);
    }

    @Override
    public Socket getSocket() {
        if (this.channel instanceof SocketChannel) {
            return ((SocketChannel)this.channel).socket();
        }
        return null;
    }
}

