/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import com.icbc.api.internal.apache.http.util.CharsetUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class SessionOutputBufferImpl
extends ExpandableBuffer
implements SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final CharsetEncoder charencoder;
    private final int lineBuffersize;
    private CharBuffer charbuffer;

    public SessionOutputBufferImpl(int n, int n2, CharsetEncoder charsetEncoder, ByteBufferAllocator byteBufferAllocator) {
        super(n, byteBufferAllocator != null ? byteBufferAllocator : HeapByteBufferAllocator.INSTANCE);
        this.lineBuffersize = Args.positive(n2, "Line buffer size");
        this.charencoder = charsetEncoder;
    }

    @Deprecated
    public SessionOutputBufferImpl(int n, int n2, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(n, byteBufferAllocator);
        this.lineBuffersize = Args.positive(n2, "Line buffer size");
        String string = (String)httpParams.getParameter("http.protocol.element-charset");
        Charset charset = CharsetUtils.lookup(string);
        if (charset != null) {
            this.charencoder = charset.newEncoder();
            CodingErrorAction codingErrorAction = (CodingErrorAction)httpParams.getParameter("http.malformed.input.action");
            this.charencoder.onMalformedInput(codingErrorAction != null ? codingErrorAction : CodingErrorAction.REPORT);
            CodingErrorAction codingErrorAction2 = (CodingErrorAction)httpParams.getParameter("http.unmappable.input.action");
            this.charencoder.onUnmappableCharacter(codingErrorAction2 != null ? codingErrorAction2 : CodingErrorAction.REPORT);
        } else {
            this.charencoder = null;
        }
    }

    @Deprecated
    public SessionOutputBufferImpl(int n, int n2, HttpParams httpParams) {
        this(n, n2, HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    public SessionOutputBufferImpl(int n) {
        this(n, 256, null, HeapByteBufferAllocator.INSTANCE);
    }

    public SessionOutputBufferImpl(int n, int n2, Charset charset) {
        this(n, n2, charset != null ? charset.newEncoder() : null, HeapByteBufferAllocator.INSTANCE);
    }

    public SessionOutputBufferImpl(int n, int n2) {
        this(n, n2, null, HeapByteBufferAllocator.INSTANCE);
    }

    public void reset(HttpParams httpParams) {
        this.clear();
    }

    @Override
    public int flush(WritableByteChannel writableByteChannel) throws IOException {
        Args.notNull(writableByteChannel, "Channel");
        this.setOutputMode();
        return writableByteChannel.write(this.buffer);
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        this.setInputMode();
        int n = this.buffer.position() + byteBuffer.remaining();
        this.ensureCapacity(n);
        this.buffer.put(byteBuffer);
    }

    @Override
    public void write(ReadableByteChannel readableByteChannel) throws IOException {
        if (readableByteChannel == null) {
            return;
        }
        this.setInputMode();
        readableByteChannel.read(this.buffer);
    }

    private void write(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.setInputMode();
        boolean bl = false;
        int n = byArray.length;
        int n2 = this.buffer.position() + n;
        this.ensureCapacity(n2);
        this.buffer.put(byArray, 0, n);
    }

    private void writeCRLF() {
        this.write(CRLF);
    }

    @Override
    public void writeLine(CharArrayBuffer charArrayBuffer) throws CharacterCodingException {
        if (charArrayBuffer == null) {
            return;
        }
        this.setInputMode();
        if (charArrayBuffer.length() > 0) {
            if (this.charencoder == null) {
                int n = this.buffer.position() + charArrayBuffer.length();
                this.ensureCapacity(n);
                if (this.buffer.hasArray()) {
                    byte[] byArray = this.buffer.array();
                    int n2 = charArrayBuffer.length();
                    int n3 = this.buffer.position();
                    for (int i = 0; i < n2; ++i) {
                        byArray[n3 + i] = (byte)charArrayBuffer.charAt(i);
                    }
                    this.buffer.position(n3 + n2);
                } else {
                    for (int i = 0; i < charArrayBuffer.length(); ++i) {
                        this.buffer.put((byte)charArrayBuffer.charAt(i));
                    }
                }
            } else {
                int n;
                if (this.charbuffer == null) {
                    this.charbuffer = CharBuffer.allocate(this.lineBuffersize);
                }
                this.charencoder.reset();
                int n4 = 0;
                for (int i = charArrayBuffer.length(); i > 0; i -= n) {
                    n = this.charbuffer.remaining();
                    boolean bl = false;
                    if (i <= n) {
                        n = i;
                        bl = true;
                    }
                    this.charbuffer.put(charArrayBuffer.buffer(), n4, n);
                    this.charbuffer.flip();
                    boolean bl2 = true;
                    while (bl2) {
                        CoderResult coderResult = this.charencoder.encode(this.charbuffer, this.buffer, bl);
                        if (coderResult.isError()) {
                            coderResult.throwException();
                        }
                        if (coderResult.isOverflow()) {
                            this.expand();
                        }
                        bl2 = !coderResult.isUnderflow();
                    }
                    this.charbuffer.compact();
                    n4 += n;
                }
                n = 1;
                while (n != 0) {
                    CoderResult coderResult = this.charencoder.flush(this.buffer);
                    if (coderResult.isError()) {
                        coderResult.throwException();
                    }
                    if (coderResult.isOverflow()) {
                        this.expand();
                    }
                    n = !coderResult.isUnderflow() ? 1 : 0;
                }
            }
        }
        this.writeCRLF();
    }

    @Override
    public void writeLine(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (string.length() > 0) {
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
            charArrayBuffer.append(string);
            this.writeLine(charArrayBuffer);
        } else {
            this.write(CRLF);
        }
    }
}

