/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionRequest;
import com.icbc.api.internal.apache.http.nio.reactor.SessionRequestCallback;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SessionRequestImpl
implements SessionRequest {
    private volatile boolean completed;
    private volatile SelectionKey key;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private final Object attachment;
    private final SessionRequestCallback callback;
    private volatile int connectTimeout;
    private volatile IOSession session = null;
    private volatile IOException exception = null;

    public SessionRequestImpl(SocketAddress socketAddress, SocketAddress socketAddress2, Object object, SessionRequestCallback sessionRequestCallback) {
        Args.notNull(socketAddress, "Remote address");
        this.remoteAddress = socketAddress;
        this.localAddress = socketAddress2;
        this.attachment = object;
        this.callback = sessionRequestCallback;
        this.connectTimeout = 0;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void setKey(SelectionKey selectionKey) {
        this.key = selectionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor() throws InterruptedException {
        if (this.completed) {
            return;
        }
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            while (!this.completed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOSession getSession() {
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            return this.session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOException getException() {
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(IOSession iOSession) {
        Args.notNull(iOSession, "Session");
        if (this.completed) {
            return;
        }
        this.completed = true;
        SessionRequestImpl sessionRequestImpl = this;
        synchronized (sessionRequestImpl) {
            this.session = iOSession;
            if (this.callback != null) {
                this.callback.completed(this);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(IOException iOException) {
        Object object;
        if (iOException == null) {
            return;
        }
        if (this.completed) {
            return;
        }
        this.completed = true;
        SelectionKey selectionKey = this.key;
        if (selectionKey != null) {
            selectionKey.cancel();
            object = selectionKey.channel();
            try {
                object.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        object = this;
        synchronized (object) {
            this.exception = iOException;
            if (this.callback != null) {
                this.callback.failed(this);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout() {
        Object object;
        if (this.completed) {
            return;
        }
        this.completed = true;
        SelectionKey selectionKey = this.key;
        if (selectionKey != null) {
            selectionKey.cancel();
            object = selectionKey.channel();
            if (object.isOpen()) {
                try {
                    object.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.callback != null) {
                this.callback.timeout(this);
            }
        }
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int n) {
        if (this.connectTimeout != n) {
            this.connectTimeout = n;
            SelectionKey selectionKey = this.key;
            if (selectionKey != null) {
                selectionKey.selector().wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object;
        if (this.completed) {
            return;
        }
        this.completed = true;
        SelectionKey selectionKey = this.key;
        if (selectionKey != null) {
            selectionKey.cancel();
            object = selectionKey.channel();
            if (object.isOpen()) {
                try {
                    object.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.callback != null) {
                this.callback.cancelled(this);
            }
            this.notifyAll();
        }
    }
}

