/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.message;

import com.icbc.api.internal.apache.http.FormattedHeader;
import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HeaderElement;
import com.icbc.api.internal.apache.http.HeaderElementIterator;
import com.icbc.api.internal.apache.http.HeaderIterator;
import com.icbc.api.internal.apache.http.message.BasicHeaderValueParser;
import com.icbc.api.internal.apache.http.message.HeaderValueParser;
import com.icbc.api.internal.apache.http.message.ParserCursor;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.util.NoSuchElementException;

public class BasicHeaderElementIterator
implements HeaderElementIterator {
    private final HeaderIterator headerIt;
    private final HeaderValueParser parser;
    private HeaderElement currentElement = null;
    private CharArrayBuffer buffer = null;
    private ParserCursor cursor = null;

    public BasicHeaderElementIterator(HeaderIterator headerIterator, HeaderValueParser headerValueParser) {
        this.headerIt = Args.notNull(headerIterator, "Header iterator");
        this.parser = Args.notNull(headerValueParser, "Parser");
    }

    public BasicHeaderElementIterator(HeaderIterator headerIterator) {
        this(headerIterator, BasicHeaderValueParser.INSTANCE);
    }

    private void bufferHeaderValue() {
        this.cursor = null;
        this.buffer = null;
        while (this.headerIt.hasNext()) {
            Header header = this.headerIt.nextHeader();
            if (header instanceof FormattedHeader) {
                this.buffer = ((FormattedHeader)header).getBuffer();
                this.cursor = new ParserCursor(0, this.buffer.length());
                this.cursor.updatePos(((FormattedHeader)header).getValuePos());
                break;
            }
            String string = header.getValue();
            if (string == null) continue;
            this.buffer = new CharArrayBuffer(string.length());
            this.buffer.append(string);
            this.cursor = new ParserCursor(0, this.buffer.length());
            break;
        }
    }

    private void parseNextElement() {
        while (this.headerIt.hasNext() || this.cursor != null) {
            if (this.cursor == null || this.cursor.atEnd()) {
                this.bufferHeaderValue();
            }
            if (this.cursor == null) continue;
            while (!this.cursor.atEnd()) {
                HeaderElement headerElement = this.parser.parseHeaderElement(this.buffer, this.cursor);
                if (headerElement.getName().length() == 0 && headerElement.getValue() == null) continue;
                this.currentElement = headerElement;
                return;
            }
            if (!this.cursor.atEnd()) continue;
            this.cursor = null;
            this.buffer = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentElement == null) {
            this.parseNextElement();
        }
        return this.currentElement != null;
    }

    @Override
    public HeaderElement nextElement() throws NoSuchElementException {
        if (this.currentElement == null) {
            this.parseNextElement();
        }
        if (this.currentElement == null) {
            throw new NoSuchElementException("No more header elements available");
        }
        HeaderElement headerElement = this.currentElement;
        this.currentElement = null;
        return headerElement;
    }

    @Override
    public final Object next() throws NoSuchElementException {
        return this.nextElement();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

