/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.message;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.ReasonPhraseCatalog;
import com.icbc.api.internal.apache.http.StatusLine;
import com.icbc.api.internal.apache.http.message.AbstractHttpMessage;
import com.icbc.api.internal.apache.http.message.BasicStatusLine;
import com.icbc.api.internal.apache.http.util.Args;
import java.util.Locale;

public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline;
    private ProtocolVersion ver;
    private int code;
    private String reasonPhrase;
    private HttpEntity entity;
    private final ReasonPhraseCatalog reasonCatalog;
    private Locale locale;

    public BasicHttpResponse(StatusLine statusLine, ReasonPhraseCatalog reasonPhraseCatalog, Locale locale) {
        this.statusline = Args.notNull(statusLine, "Status line");
        this.ver = statusLine.getProtocolVersion();
        this.code = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
        this.reasonCatalog = reasonPhraseCatalog;
        this.locale = locale;
    }

    public BasicHttpResponse(StatusLine statusLine) {
        this.statusline = Args.notNull(statusLine, "Status line");
        this.ver = statusLine.getProtocolVersion();
        this.code = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
        this.reasonCatalog = null;
        this.locale = null;
    }

    public BasicHttpResponse(ProtocolVersion protocolVersion, int n, String string) {
        Args.notNegative(n, "Status code");
        this.statusline = null;
        this.ver = protocolVersion;
        this.code = n;
        this.reasonPhrase = string;
        this.reasonCatalog = null;
        this.locale = null;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.ver;
    }

    @Override
    public StatusLine getStatusLine() {
        if (this.statusline == null) {
            this.statusline = new BasicStatusLine(this.ver != null ? this.ver : HttpVersion.HTTP_1_1, this.code, this.reasonPhrase != null ? this.reasonPhrase : this.getReason(this.code));
        }
        return this.statusline;
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setStatusLine(StatusLine statusLine) {
        this.statusline = Args.notNull(statusLine, "Status line");
        this.ver = statusLine.getProtocolVersion();
        this.code = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
    }

    @Override
    public void setStatusLine(ProtocolVersion protocolVersion, int n) {
        Args.notNegative(n, "Status code");
        this.statusline = null;
        this.ver = protocolVersion;
        this.code = n;
        this.reasonPhrase = null;
    }

    @Override
    public void setStatusLine(ProtocolVersion protocolVersion, int n, String string) {
        Args.notNegative(n, "Status code");
        this.statusline = null;
        this.ver = protocolVersion;
        this.code = n;
        this.reasonPhrase = string;
    }

    @Override
    public void setStatusCode(int n) {
        Args.notNegative(n, "Status code");
        this.statusline = null;
        this.code = n;
        this.reasonPhrase = null;
    }

    @Override
    public void setReasonPhrase(String string) {
        this.statusline = null;
        this.reasonPhrase = string;
    }

    @Override
    public void setEntity(HttpEntity httpEntity) {
        this.entity = httpEntity;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = Args.notNull(locale, "Locale");
        this.statusline = null;
    }

    protected String getReason(int n) {
        return this.reasonCatalog != null ? this.reasonCatalog.getReason(n, this.locale != null ? this.locale : Locale.getDefault()) : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getStatusLine());
        stringBuilder.append(' ');
        stringBuilder.append(this.headergroup);
        if (this.entity != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.entity);
        }
        return stringBuilder.toString();
    }
}

