/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.message;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.message.ParserCursor;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.util.BitSet;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class TokenParser {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final char DQUOTE = '\"';
    public static final char ESCAPE = '\\';
    public static final TokenParser INSTANCE = new TokenParser();

    public static BitSet INIT_BITSET(int ... nArray) {
        BitSet bitSet = new BitSet();
        for (int n : nArray) {
            bitSet.set(n);
        }
        return bitSet;
    }

    public static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    public String parseToken(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!parserCursor.atEnd()) {
            char c2 = charArrayBuffer.charAt(parserCursor.getPos());
            if (bitSet != null && bitSet.get(c2)) break;
            if (TokenParser.isWhitespace(c2)) {
                this.skipWhiteSpace(charArrayBuffer, parserCursor);
                bl = true;
                continue;
            }
            if (bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyContent(charArrayBuffer, parserCursor, bitSet, stringBuilder);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public String parseValue(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!parserCursor.atEnd()) {
            char c2 = charArrayBuffer.charAt(parserCursor.getPos());
            if (bitSet != null && bitSet.get(c2)) break;
            if (TokenParser.isWhitespace(c2)) {
                this.skipWhiteSpace(charArrayBuffer, parserCursor);
                bl = true;
                continue;
            }
            if (c2 == '\"') {
                if (bl && stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                this.copyQuotedContent(charArrayBuffer, parserCursor, stringBuilder);
                bl = false;
                continue;
            }
            if (bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyUnquotedContent(charArrayBuffer, parserCursor, bitSet, stringBuilder);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public void skipWhiteSpace(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        char c2;
        int n = parserCursor.getPos();
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getUpperBound();
        for (int i = n2; i < n3 && TokenParser.isWhitespace(c2 = charArrayBuffer.charAt(i)); ++i) {
            ++n;
        }
        parserCursor.updatePos(n);
    }

    public void copyContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet, StringBuilder stringBuilder) {
        int n = parserCursor.getPos();
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getUpperBound();
        for (int i = n2; i < n3; ++i) {
            char c2 = charArrayBuffer.charAt(i);
            if (bitSet != null && bitSet.get(c2) || TokenParser.isWhitespace(c2)) break;
            ++n;
            stringBuilder.append(c2);
        }
        parserCursor.updatePos(n);
    }

    public void copyUnquotedContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet, StringBuilder stringBuilder) {
        int n = parserCursor.getPos();
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getUpperBound();
        for (int i = n2; i < n3; ++i) {
            char c2 = charArrayBuffer.charAt(i);
            if (bitSet != null && bitSet.get(c2) || TokenParser.isWhitespace(c2) || c2 == '\"') break;
            ++n;
            stringBuilder.append(c2);
        }
        parserCursor.updatePos(n);
    }

    public void copyQuotedContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, StringBuilder stringBuilder) {
        if (parserCursor.atEnd()) {
            return;
        }
        int n = parserCursor.getPos();
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getUpperBound();
        char c2 = charArrayBuffer.charAt(n);
        if (c2 != '\"') {
            return;
        }
        ++n;
        boolean bl = false;
        int n4 = ++n2;
        while (n4 < n3) {
            c2 = charArrayBuffer.charAt(n4);
            if (bl) {
                if (c2 != '\"' && c2 != '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
                bl = false;
            } else {
                if (c2 == '\"') {
                    ++n;
                    break;
                }
                if (c2 == '\\') {
                    bl = true;
                } else if (c2 != '\r' && c2 != '\n') {
                    stringBuilder.append(c2);
                }
            }
            ++n4;
            ++n;
        }
        parserCursor.updatePos(n);
    }
}

