/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.client.methods;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AsyncByteConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final ByteBuffer bbuf;

    public AsyncByteConsumer(int n) {
        this.bbuf = ByteBuffer.allocate(n);
    }

    public AsyncByteConsumer() {
        this(8192);
    }

    protected abstract void onByteReceived(ByteBuffer var1, IOControl var2) throws IOException;

    @Override
    protected final void onEntityEnclosed(HttpEntity httpEntity, ContentType contentType) throws IOException {
    }

    @Override
    protected final void onContentReceived(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        Asserts.notNull(this.bbuf, "Byte buffer");
        int n = contentDecoder.read(this.bbuf);
        if (n <= 0) {
            return;
        }
        this.bbuf.flip();
        this.onByteReceived(this.bbuf, iOControl);
        this.bbuf.clear();
    }

    @Override
    protected void releaseResources() {
    }
}

