/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.client.methods;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.client.utils.URIUtils;
import com.icbc.api.internal.apache.http.entity.BasicHttpEntity;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoderChannel;
import com.icbc.api.internal.apache.http.nio.FileContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;

abstract class BaseZeroCopyRequestProducer
implements HttpAsyncRequestProducer {
    private final URI requestURI;
    private final File file;
    private final RandomAccessFile accessfile;
    private final ContentType contentType;
    private FileChannel fileChannel;
    private long idx = -1L;

    protected BaseZeroCopyRequestProducer(URI uRI, File file, ContentType contentType) throws FileNotFoundException {
        Args.notNull(uRI, "Request URI");
        Args.notNull(file, "Source file");
        this.requestURI = uRI;
        this.file = file;
        this.accessfile = new RandomAccessFile(file, "r");
        this.contentType = contentType;
    }

    private void closeChannel() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.close();
            this.fileChannel = null;
        }
    }

    protected abstract HttpEntityEnclosingRequest createRequest(URI var1, HttpEntity var2);

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        basicHttpEntity.setChunked(false);
        basicHttpEntity.setContentLength(this.file.length());
        if (this.contentType != null) {
            basicHttpEntity.setContentType(this.contentType.toString());
        }
        return this.createRequest(this.requestURI, basicHttpEntity);
    }

    @Override
    public synchronized HttpHost getTarget() {
        return URIUtils.extractHost(this.requestURI);
    }

    @Override
    public synchronized void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        long l;
        if (this.fileChannel == null) {
            this.fileChannel = this.accessfile.getChannel();
            this.idx = 0L;
        }
        if ((l = contentEncoder instanceof FileContentEncoder ? ((FileContentEncoder)contentEncoder).transfer(this.fileChannel, this.idx, Integer.MAX_VALUE) : this.fileChannel.transferTo(this.idx, Integer.MAX_VALUE, new ContentEncoderChannel(contentEncoder))) > 0L) {
            this.idx += l;
        }
        if (this.idx >= this.fileChannel.size()) {
            contentEncoder.complete();
            this.closeChannel();
        }
    }

    @Override
    public void requestCompleted(HttpContext httpContext) {
    }

    @Override
    public void failed(Exception exception) {
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public synchronized void resetRequest() throws IOException {
        this.closeChannel();
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.accessfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

