/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.conn.ssl;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.conn.ssl.AllowAllHostnameVerifier;
import com.icbc.api.internal.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import com.icbc.api.internal.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.icbc.api.internal.apache.http.conn.ssl.StrictHostnameVerifier;
import com.icbc.api.internal.apache.http.conn.ssl.X509HostnameVerifier;
import com.icbc.api.internal.apache.http.conn.util.PublicSuffixMatcherLoader;
import com.icbc.api.internal.apache.http.nio.conn.SchemeIOSessionStrategy;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLIOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLMode;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.ssl.SSLContexts;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import com.icbc.api.internal.apache.http.util.TextUtils;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public class SSLIOSessionStrategy
implements SchemeIOSessionStrategy {
    @Deprecated
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    @Deprecated
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    @Deprecated
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private final SSLContext sslContext;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;
    private final HostnameVerifier hostnameVerifier;

    private static String[] split(String string) {
        if (TextUtils.isBlank(string)) {
            return null;
        }
        return string.split(" *, *");
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
    }

    public static SSLIOSessionStrategy getDefaultStrategy() {
        return new SSLIOSessionStrategy(SSLContexts.createDefault(), SSLIOSessionStrategy.getDefaultHostnameVerifier());
    }

    public static SSLIOSessionStrategy getSystemDefaultStrategy() {
        return new SSLIOSessionStrategy(SSLContexts.createSystemDefault(), SSLIOSessionStrategy.split(System.getProperty("https.protocols")), SSLIOSessionStrategy.split(System.getProperty("https.cipherSuites")), SSLIOSessionStrategy.getDefaultHostnameVerifier());
    }

    @Deprecated
    public SSLIOSessionStrategy(SSLContext sSLContext, String[] stringArray, String[] stringArray2, X509HostnameVerifier x509HostnameVerifier) {
        this(sSLContext, stringArray, stringArray2, (HostnameVerifier)x509HostnameVerifier);
    }

    @Deprecated
    public SSLIOSessionStrategy(SSLContext sSLContext, X509HostnameVerifier x509HostnameVerifier) {
        this(sSLContext, null, null, (HostnameVerifier)x509HostnameVerifier);
    }

    public SSLIOSessionStrategy(SSLContext sSLContext, String[] stringArray, String[] stringArray2, HostnameVerifier hostnameVerifier) {
        this.sslContext = Args.notNull(sSLContext, "SSL context");
        this.supportedProtocols = stringArray;
        this.supportedCipherSuites = stringArray2;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : SSLIOSessionStrategy.getDefaultHostnameVerifier();
    }

    public SSLIOSessionStrategy(SSLContext sSLContext, HostnameVerifier hostnameVerifier) {
        this(sSLContext, null, null, hostnameVerifier);
    }

    public SSLIOSessionStrategy(SSLContext sSLContext) {
        this(sSLContext, null, null, SSLIOSessionStrategy.getDefaultHostnameVerifier());
    }

    @Override
    public SSLIOSession upgrade(final HttpHost httpHost, IOSession iOSession) throws IOException {
        Asserts.check(!(iOSession instanceof SSLIOSession), "I/O session is already upgraded to TLS/SSL");
        SSLIOSession sSLIOSession = new SSLIOSession(iOSession, SSLMode.CLIENT, httpHost, this.sslContext, new SSLSetupHandler(){

            @Override
            public void initalize(SSLEngine sSLEngine) throws SSLException {
                if (SSLIOSessionStrategy.this.supportedProtocols != null) {
                    sSLEngine.setEnabledProtocols(SSLIOSessionStrategy.this.supportedProtocols);
                }
                if (SSLIOSessionStrategy.this.supportedCipherSuites != null) {
                    sSLEngine.setEnabledCipherSuites(SSLIOSessionStrategy.this.supportedCipherSuites);
                }
                SSLIOSessionStrategy.this.initializeEngine(sSLEngine);
            }

            @Override
            public void verify(IOSession iOSession, SSLSession sSLSession) throws SSLException {
                SSLIOSessionStrategy.this.verifySession(httpHost, iOSession, sSLSession);
            }
        });
        iOSession.setAttribute("http.session.ssl", sSLIOSession);
        sSLIOSession.initialize();
        return sSLIOSession;
    }

    protected void initializeEngine(SSLEngine sSLEngine) {
    }

    protected void verifySession(HttpHost httpHost, IOSession iOSession, SSLSession sSLSession) throws SSLException {
        if (!this.hostnameVerifier.verify(httpHost.getHostName(), sSLSession)) {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            throw new SSLPeerUnverifiedException("Host name '" + httpHost.getHostName() + "' does not match the certificate subject provided by the peer (" + x500Principal.toString() + ")");
        }
    }

    @Override
    public boolean isLayeringRequired() {
        return true;
    }
}

