/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.entity;

import com.icbc.api.internal.apache.http.io.BufferInfo;
import com.icbc.api.internal.apache.http.nio.util.ContentInputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;

public class ContentInputStream
extends InputStream {
    private final ContentInputBuffer buffer;

    public ContentInputStream(ContentInputBuffer contentInputBuffer) {
        Args.notNull(contentInputBuffer, "Input buffer");
        this.buffer = contentInputBuffer;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer instanceof BufferInfo) {
            return ((BufferInfo)((Object)this.buffer)).length();
        }
        return super.available();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.buffer.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            return 0;
        }
        return this.buffer.read(byArray, 0, byArray.length);
    }

    @Override
    public int read() throws IOException {
        return this.buffer.read();
    }

    @Override
    public void close() throws IOException {
        byte[] byArray = new byte[1024];
        while (this.buffer.read(byArray, 0, byArray.length) >= 0) {
        }
        super.close();
    }
}

