/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.entity;

import com.icbc.api.internal.apache.http.nio.util.ContentOutputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;

public class ContentOutputStream
extends OutputStream {
    private final ContentOutputBuffer buffer;

    public ContentOutputStream(ContentOutputBuffer contentOutputBuffer) {
        Args.notNull(contentOutputBuffer, "Output buffer");
        this.buffer = contentOutputBuffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.writeCompleted();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.buffer.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.buffer.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer.write(n);
    }
}

