/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.entity;

import com.icbc.api.internal.apache.http.entity.AbstractHttpEntity;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.ProducingNHttpEntity;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class NByteArrayEntity
extends AbstractHttpEntity
implements HttpAsyncContentProducer,
ProducingNHttpEntity {
    private final byte[] b;
    private final int off;
    private final int len;
    private final ByteBuffer buf;
    @Deprecated
    protected final byte[] content;
    @Deprecated
    protected final ByteBuffer buffer;

    public NByteArrayEntity(byte[] byArray, ContentType contentType) {
        Args.notNull(byArray, "Source byte array");
        this.b = byArray;
        this.off = 0;
        this.len = byArray.length;
        this.buf = ByteBuffer.wrap(byArray);
        this.content = byArray;
        this.buffer = this.buf;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public NByteArrayEntity(byte[] byArray, int n, int n2, ContentType contentType) {
        Args.notNull(byArray, "Source byte array");
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n + " len: " + n2 + " b.length: " + byArray.length);
        }
        this.b = byArray;
        this.off = n;
        this.len = n2;
        this.buf = ByteBuffer.wrap(byArray, n, n2);
        this.content = byArray;
        this.buffer = this.buf;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public NByteArrayEntity(byte[] byArray) {
        this(byArray, null);
    }

    public NByteArrayEntity(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, null);
    }

    @Override
    public void close() {
        this.buf.rewind();
    }

    @Override
    @Deprecated
    public void finish() {
        this.close();
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        contentEncoder.write(this.buf);
        if (!this.buf.hasRemaining()) {
            contentEncoder.complete();
        }
    }

    @Override
    public long getContentLength() {
        return this.len;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        outputStream.write(this.b, this.off, this.len);
        outputStream.flush();
    }
}

