/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.pool;

import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.pool.PoolEntry;
import java.util.concurrent.atomic.AtomicBoolean;

class LeaseRequest<T, C, E extends PoolEntry<T, C>> {
    private final T route;
    private final Object state;
    private final long connectTimeout;
    private final long deadline;
    private final BasicFuture<E> future;
    private final AtomicBoolean completed;
    private volatile E result;
    private volatile Exception ex;

    public LeaseRequest(T t, Object object, long l, long l2, BasicFuture<E> basicFuture) {
        this.route = t;
        this.state = object;
        this.connectTimeout = l;
        this.deadline = l2 > 0L ? System.currentTimeMillis() + l2 : Long.MAX_VALUE;
        this.future = basicFuture;
        this.completed = new AtomicBoolean(false);
    }

    public T getRoute() {
        return this.route;
    }

    public Object getState() {
        return this.state;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public boolean isDone() {
        return this.completed.get();
    }

    public void failed(Exception exception) {
        if (this.completed.compareAndSet(false, true)) {
            this.ex = exception;
        }
    }

    public void completed(E e) {
        if (this.completed.compareAndSet(false, true)) {
            this.result = e;
        }
    }

    public BasicFuture<E> getFuture() {
        return this.future;
    }

    public E getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.ex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.route);
        stringBuilder.append("][");
        stringBuilder.append(this.state);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

