/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.pool;

import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.nio.reactor.SessionRequest;
import com.icbc.api.internal.apache.http.pool.PoolEntry;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

abstract class RouteSpecificPool<T, C, E extends PoolEntry<T, C>> {
    private final T route;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final Map<SessionRequest, BasicFuture<E>> pending;

    RouteSpecificPool(T t) {
        this.route = t;
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.pending = new HashMap<SessionRequest, BasicFuture<E>>();
    }

    public T getRoute() {
        return this.route;
    }

    protected abstract E createEntry(T var1, C var2);

    public int getLeasedCount() {
        return this.leased.size();
    }

    public int getPendingCount() {
        return this.pending.size();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public int getAllocatedCount() {
        return this.available.size() + this.leased.size() + this.pending.size();
    }

    public E getFree(Object object) {
        if (!this.available.isEmpty()) {
            PoolEntry poolEntry;
            Iterator iterator;
            if (object != null) {
                iterator = this.available.iterator();
                while (iterator.hasNext()) {
                    poolEntry = (PoolEntry)iterator.next();
                    if (!object.equals(poolEntry.getState())) continue;
                    iterator.remove();
                    this.leased.add(poolEntry);
                    return (E)poolEntry;
                }
            }
            iterator = this.available.iterator();
            while (iterator.hasNext()) {
                poolEntry = (PoolEntry)iterator.next();
                if (poolEntry.getState() != null) continue;
                iterator.remove();
                this.leased.add(poolEntry);
                return (E)poolEntry;
            }
        }
        return null;
    }

    public E getLastUsed() {
        if (!this.available.isEmpty()) {
            return (E)((PoolEntry)this.available.getLast());
        }
        return null;
    }

    public boolean remove(E e) {
        Args.notNull(e, "Pool entry");
        return this.available.remove(e) || this.leased.remove(e);
    }

    public void free(E e, boolean bl) {
        Args.notNull(e, "Pool entry");
        boolean bl2 = this.leased.remove(e);
        Asserts.check(bl2, "Entry %s has not been leased from this pool", e);
        if (bl) {
            this.available.addFirst(e);
        }
    }

    public void addPending(SessionRequest sessionRequest, BasicFuture<E> basicFuture) {
        this.pending.put(sessionRequest, basicFuture);
    }

    private BasicFuture<E> removeRequest(SessionRequest sessionRequest) {
        BasicFuture<E> basicFuture = this.pending.remove(sessionRequest);
        Asserts.notNull(basicFuture, "Session request future");
        return basicFuture;
    }

    public E createEntry(SessionRequest sessionRequest, C c2) {
        E e = this.createEntry(this.route, c2);
        this.leased.add(e);
        return e;
    }

    public void completed(SessionRequest sessionRequest, E e) {
        BasicFuture<E> basicFuture = this.removeRequest(sessionRequest);
        basicFuture.completed(e);
    }

    public void cancelled(SessionRequest sessionRequest) {
        BasicFuture<E> basicFuture = this.removeRequest(sessionRequest);
        basicFuture.cancel(true);
    }

    public void failed(SessionRequest sessionRequest, Exception exception) {
        BasicFuture<E> basicFuture = this.removeRequest(sessionRequest);
        basicFuture.failed(exception);
    }

    public void timeout(SessionRequest sessionRequest) {
        BasicFuture<E> basicFuture = this.removeRequest(sessionRequest);
        basicFuture.failed(new ConnectException());
    }

    public void shutdown() {
        for (SessionRequest object : this.pending.keySet()) {
            object.cancel();
        }
        this.pending.clear();
        for (PoolEntry poolEntry : this.available) {
            poolEntry.close();
        }
        this.available.clear();
        for (PoolEntry poolEntry : this.leased) {
            poolEntry.close();
        }
        this.leased.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[route: ");
        stringBuilder.append(this.route);
        stringBuilder.append("][leased: ");
        stringBuilder.append(this.leased.size());
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available.size());
        stringBuilder.append("][pending: ");
        stringBuilder.append(this.pending.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

