/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class BasicAsyncClientExchangeHandler<T>
implements HttpAsyncClientExchangeHandler {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final BasicFuture<T> future;
    private final HttpContext localContext;
    private final NHttpClientConnection conn;
    private final HttpProcessor httppocessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final AtomicBoolean requestSent;
    private final AtomicBoolean keepAlive;
    private final AtomicBoolean closed;

    public BasicAsyncClientExchangeHandler(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, FutureCallback<T> futureCallback, HttpContext httpContext, NHttpClientConnection nHttpClientConnection, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy) {
        this.requestProducer = Args.notNull(httpAsyncRequestProducer, "Request producer");
        this.responseConsumer = Args.notNull(httpAsyncResponseConsumer, "Response consumer");
        this.future = new BasicFuture<T>(futureCallback);
        this.localContext = Args.notNull(httpContext, "HTTP context");
        this.conn = Args.notNull(nHttpClientConnection, "HTTP connection");
        this.httppocessor = Args.notNull(httpProcessor, "HTTP processor");
        this.connReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.requestSent = new AtomicBoolean(false);
        this.keepAlive = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    public BasicAsyncClientExchangeHandler(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpContext httpContext, NHttpClientConnection nHttpClientConnection, HttpProcessor httpProcessor) {
        this(httpAsyncRequestProducer, httpAsyncResponseConsumer, null, httpContext, nHttpClientConnection, httpProcessor, null);
    }

    public Future<T> getFuture() {
        return this.future;
    }

    private void releaseResources() {
        try {
            this.responseConsumer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.requestProducer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.releaseResources();
            if (!this.future.isDone()) {
                this.future.cancel();
            }
        }
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        if (this.isDone()) {
            return null;
        }
        HttpRequest httpRequest = this.requestProducer.generateRequest();
        this.localContext.setAttribute("http.request", httpRequest);
        this.localContext.setAttribute("http.connection", this.conn);
        this.httppocessor.process(httpRequest, this.localContext);
        return httpRequest;
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        this.requestProducer.produceContent(contentEncoder, iOControl);
    }

    @Override
    public void requestCompleted() {
        this.requestProducer.requestCompleted(this.localContext);
        this.requestSent.set(true);
    }

    @Override
    public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        this.localContext.setAttribute("http.response", httpResponse);
        this.httppocessor.process(httpResponse, this.localContext);
        this.responseConsumer.responseReceived(httpResponse);
        this.keepAlive.set(this.connReuseStrategy.keepAlive(httpResponse, this.localContext));
    }

    @Override
    public void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        this.responseConsumer.consumeContent(contentDecoder, iOControl);
    }

    @Override
    public void responseCompleted() throws IOException {
        try {
            if (!this.keepAlive.get()) {
                this.conn.close();
            }
            this.responseConsumer.responseCompleted(this.localContext);
            T t = this.responseConsumer.getResult();
            Exception exception = this.responseConsumer.getException();
            if (t != null) {
                this.future.completed(t);
            } else {
                this.future.failed(exception);
            }
            if (this.closed.compareAndSet(false, true)) {
                this.releaseResources();
            }
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void inputTerminated() {
        this.failed(new ConnectionClosedException("Connection closed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Exception exception) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (!this.requestSent.get()) {
                    this.requestProducer.failed(exception);
                }
                this.responseConsumer.failed(exception);
            }
            finally {
                try {
                    this.future.failed(exception);
                }
                finally {
                    this.releaseResources();
                }
            }
        }
    }

    @Override
    public boolean cancel() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                boolean bl;
                try {
                    bl = this.responseConsumer.cancel();
                    this.future.cancel();
                }
                catch (Throwable throwable) {
                    this.future.cancel();
                    throw throwable;
                }
                return bl;
            }
            finally {
                this.releaseResources();
            }
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this.responseConsumer.isDone();
    }
}

