/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestExecutionHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.Future;

@Deprecated
public class BasicAsyncRequestExecutionHandler<T>
implements HttpAsyncRequestExecutionHandler<T> {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final BasicFuture<T> future;
    private final HttpContext localContext;
    private final HttpProcessor httppocessor;
    private final ConnectionReuseStrategy reuseStrategy;
    private volatile boolean requestSent;

    public BasicAsyncRequestExecutionHandler(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, FutureCallback<T> futureCallback, HttpContext httpContext, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpParams httpParams) {
        Args.notNull(httpAsyncRequestProducer, "Request producer");
        Args.notNull(httpAsyncResponseConsumer, "Response consumer");
        Args.notNull(httpContext, "HTTP context");
        Args.notNull(httpProcessor, "HTTP processor");
        Args.notNull(connectionReuseStrategy, "Connection reuse strategy");
        Args.notNull(httpParams, "HTTP parameters");
        this.requestProducer = httpAsyncRequestProducer;
        this.responseConsumer = httpAsyncResponseConsumer;
        this.future = new BasicFuture<T>(futureCallback);
        this.localContext = httpContext;
        this.httppocessor = httpProcessor;
        this.reuseStrategy = connectionReuseStrategy;
    }

    public BasicAsyncRequestExecutionHandler(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpContext httpContext, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpParams httpParams) {
        this(httpAsyncRequestProducer, httpAsyncResponseConsumer, null, httpContext, httpProcessor, connectionReuseStrategy, httpParams);
    }

    public Future<T> getFuture() {
        return this.future;
    }

    private void releaseResources() {
        try {
            this.responseConsumer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.requestProducer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.releaseResources();
        if (!this.future.isDone()) {
            this.future.cancel();
        }
    }

    @Override
    public HttpHost getTarget() {
        return this.requestProducer.getTarget();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        return this.requestProducer.generateRequest();
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        this.requestProducer.produceContent(contentEncoder, iOControl);
    }

    @Override
    public void requestCompleted(HttpContext httpContext) {
        this.requestProducer.requestCompleted(httpContext);
        this.requestSent = true;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public void resetRequest() {
    }

    @Override
    public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        this.responseConsumer.responseReceived(httpResponse);
    }

    @Override
    public void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        this.responseConsumer.consumeContent(contentDecoder, iOControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Exception exception) {
        try {
            if (!this.requestSent) {
                this.requestProducer.failed(exception);
            }
            this.responseConsumer.failed(exception);
        }
        finally {
            try {
                this.future.failed(exception);
            }
            finally {
                this.releaseResources();
            }
        }
    }

    @Override
    public boolean cancel() {
        try {
            boolean bl = this.responseConsumer.cancel();
            this.future.cancel();
            this.releaseResources();
            return bl;
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void responseCompleted(HttpContext httpContext) {
        try {
            this.responseConsumer.responseCompleted(httpContext);
            T t = this.responseConsumer.getResult();
            Exception exception = this.responseConsumer.getException();
            if (exception == null) {
                this.future.completed(t);
            } else {
                this.future.failed(exception);
            }
            this.releaseResources();
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public T getResult() {
        return this.responseConsumer.getResult();
    }

    @Override
    public Exception getException() {
        return this.responseConsumer.getException();
    }

    @Override
    public HttpContext getContext() {
        return this.localContext;
    }

    @Override
    public HttpProcessor getHttpProcessor() {
        return this.httppocessor;
    }

    @Override
    public ConnectionReuseStrategy getConnectionReuseStrategy() {
        return this.reuseStrategy;
    }

    @Override
    public boolean isDone() {
        return this.responseConsumer.isDone();
    }
}

