/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.EntityAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

public class BasicAsyncRequestProducer
implements HttpAsyncRequestProducer {
    private final HttpHost target;
    private final HttpRequest request;
    private final HttpAsyncContentProducer producer;

    protected BasicAsyncRequestProducer(HttpHost httpHost, HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpAsyncContentProducer httpAsyncContentProducer) {
        Args.notNull(httpHost, "HTTP host");
        Args.notNull(httpEntityEnclosingRequest, "HTTP request");
        Args.notNull(httpAsyncContentProducer, "HTTP content producer");
        this.target = httpHost;
        this.request = httpEntityEnclosingRequest;
        this.producer = httpAsyncContentProducer;
    }

    public BasicAsyncRequestProducer(HttpHost httpHost, HttpRequest httpRequest) {
        HttpEntity httpEntity;
        Args.notNull(httpHost, "HTTP host");
        Args.notNull(httpRequest, "HTTP request");
        this.target = httpHost;
        this.request = httpRequest;
        this.producer = httpRequest instanceof HttpEntityEnclosingRequest ? ((httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity()) != null ? (httpEntity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)httpEntity) : new EntityAsyncContentProducer(httpEntity)) : null) : null;
    }

    @Override
    public HttpRequest generateRequest() {
        return this.request;
    }

    @Override
    public HttpHost getTarget() {
        return this.target;
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        if (this.producer != null) {
            this.producer.produceContent(contentEncoder, iOControl);
            if (contentEncoder.isCompleted()) {
                this.producer.close();
            }
        }
    }

    @Override
    public void requestCompleted(HttpContext httpContext) {
    }

    @Override
    public void failed(Exception exception) {
    }

    @Override
    public boolean isRepeatable() {
        return this.producer == null || this.producer.isRepeatable();
    }

    @Override
    public void resetRequest() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.target);
        stringBuilder.append(' ');
        stringBuilder.append(this.request);
        if (this.producer != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.producer);
        }
        return stringBuilder.toString();
    }
}

