/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.EntityAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseProducer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import java.io.IOException;

class ErrorResponseProducer
implements HttpAsyncResponseProducer {
    private final HttpResponse response;
    private final HttpEntity entity;
    private final HttpAsyncContentProducer contentProducer;
    private final boolean keepAlive;

    ErrorResponseProducer(HttpResponse httpResponse, HttpEntity httpEntity, boolean bl) {
        this.response = httpResponse;
        this.entity = httpEntity;
        this.contentProducer = httpEntity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)httpEntity) : new EntityAsyncContentProducer(httpEntity);
        this.keepAlive = bl;
    }

    @Override
    public HttpResponse generateResponse() {
        if (this.keepAlive) {
            this.response.addHeader("Connection", "Keep-Alive");
        } else {
            this.response.addHeader("Connection", "Close");
        }
        this.response.setEntity(this.entity);
        return this.response;
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        this.contentProducer.produceContent(contentEncoder, iOControl);
    }

    @Override
    public void responseCompleted(HttpContext httpContext) {
    }

    @Override
    public void failed(Exception exception) {
    }

    @Override
    public void close() throws IOException {
        this.contentProducer.close();
    }
}

