/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.nio.ByteBuffer;

class NullRequestConsumer
implements HttpAsyncRequestConsumer<Object> {
    private final ByteBuffer buffer = ByteBuffer.allocate(2048);
    private volatile boolean completed;

    NullRequestConsumer() {
    }

    @Override
    public void requestReceived(HttpRequest httpRequest) {
    }

    @Override
    public void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        int n;
        do {
            this.buffer.clear();
        } while ((n = contentDecoder.read(this.buffer)) > 0);
    }

    @Override
    public void requestCompleted(HttpContext httpContext) {
        this.completed = true;
    }

    @Override
    public void failed(Exception exception) {
        this.completed = true;
    }

    @Override
    public Object getResult() {
        return this.completed;
    }

    @Override
    public Exception getException() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.completed = true;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }
}

