/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.NHttpClientHandler;
import com.icbc.api.internal.apache.http.nio.entity.ContentBufferEntity;
import com.icbc.api.internal.apache.http.nio.entity.ContentOutputStream;
import com.icbc.api.internal.apache.http.nio.protocol.HttpRequestExecutionHandler;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpHandlerBase;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ContentOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.DirectByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.SharedInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.SharedOutputBuffer;
import com.icbc.api.internal.apache.http.params.DefaultedHttpParams;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ThrottlingHttpClientHandler
extends NHttpHandlerBase
implements NHttpClientHandler {
    protected HttpRequestExecutionHandler execHandler;
    protected final Executor executor;
    private final int bufsize;

    public ThrottlingHttpClientHandler(HttpProcessor httpProcessor, HttpRequestExecutionHandler httpRequestExecutionHandler, ConnectionReuseStrategy connectionReuseStrategy, ByteBufferAllocator byteBufferAllocator, Executor executor, HttpParams httpParams) {
        super(httpProcessor, connectionReuseStrategy, byteBufferAllocator, httpParams);
        Args.notNull(httpRequestExecutionHandler, "HTTP request execution handler");
        Args.notNull(executor, "Executor");
        this.execHandler = httpRequestExecutionHandler;
        this.executor = executor;
        this.bufsize = this.params.getIntParameter("http.nio.content-buffer-size", 20480);
    }

    public ThrottlingHttpClientHandler(HttpProcessor httpProcessor, HttpRequestExecutionHandler httpRequestExecutionHandler, ConnectionReuseStrategy connectionReuseStrategy, Executor executor, HttpParams httpParams) {
        this(httpProcessor, httpRequestExecutionHandler, connectionReuseStrategy, DirectByteBufferAllocator.INSTANCE, executor, httpParams);
    }

    @Override
    public void connected(NHttpClientConnection nHttpClientConnection, Object object) {
        HttpContext httpContext = nHttpClientConnection.getContext();
        this.initialize(nHttpClientConnection, object);
        ClientConnState clientConnState = new ClientConnState(this.bufsize, nHttpClientConnection, this.allocator);
        httpContext.setAttribute("http.nio.conn-state", clientConnState);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen(nHttpClientConnection);
        }
        this.requestReady(nHttpClientConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(NHttpClientConnection nHttpClientConnection) {
        HttpContext httpContext = nHttpClientConnection.getContext();
        ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
        if (clientConnState != null) {
            ClientConnState clientConnState2 = clientConnState;
            synchronized (clientConnState2) {
                clientConnState.close();
                clientConnState.notifyAll();
            }
        }
        this.execHandler.finalizeContext(httpContext);
        if (this.eventListener != null) {
            this.eventListener.connectionClosed(nHttpClientConnection);
        }
    }

    @Override
    public void exception(NHttpClientConnection nHttpClientConnection, HttpException httpException) {
        this.closeConnection(nHttpClientConnection, httpException);
        if (this.eventListener != null) {
            this.eventListener.fatalProtocolException(httpException, nHttpClientConnection);
        }
    }

    @Override
    public void exception(NHttpClientConnection nHttpClientConnection, IOException iOException) {
        this.shutdownConnection(nHttpClientConnection, iOException);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(iOException, nHttpClientConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestReady(NHttpClientConnection nHttpClientConnection) {
        block12: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState2 = clientConnState;
                synchronized (clientConnState2) {
                    if (clientConnState.getOutputState() != 0) {
                        return;
                    }
                    HttpRequest httpRequest = this.execHandler.submitRequest(httpContext);
                    if (httpRequest == null) {
                        return;
                    }
                    httpRequest.setParams(new DefaultedHttpParams(httpRequest.getParams(), this.params));
                    httpContext.setAttribute("http.request", httpRequest);
                    this.httpProcessor.process(httpRequest, httpContext);
                    clientConnState.setRequest(httpRequest);
                    nHttpClientConnection.submitRequest(httpRequest);
                    clientConnState.setOutputState(1);
                    nHttpClientConnection.requestInput();
                    if (httpRequest instanceof HttpEntityEnclosingRequest) {
                        if (((HttpEntityEnclosingRequest)httpRequest).expectContinue()) {
                            int n = nHttpClientConnection.getSocketTimeout();
                            clientConnState.setTimeout(n);
                            n = this.params.getIntParameter("http.protocol.wait-for-continue", 3000);
                            nHttpClientConnection.setSocketTimeout(n);
                            clientConnState.setOutputState(2);
                        } else {
                            this.sendRequestBody((HttpEntityEnclosingRequest)httpRequest, clientConnState, nHttpClientConnection);
                        }
                    }
                    clientConnState.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpClientConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpClientConnection, httpException);
                if (this.eventListener == null) break block12;
                this.eventListener.fatalProtocolException(httpException, nHttpClientConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outputReady(NHttpClientConnection nHttpClientConnection, ContentEncoder contentEncoder) {
        block8: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState2 = clientConnState;
                synchronized (clientConnState2) {
                    if (clientConnState.getOutputState() == 2) {
                        nHttpClientConnection.suspendOutput();
                        return;
                    }
                    ContentOutputBuffer contentOutputBuffer = clientConnState.getOutbuffer();
                    contentOutputBuffer.produceContent(contentEncoder);
                    if (contentEncoder.isCompleted()) {
                        clientConnState.setInputState(8);
                    } else {
                        clientConnState.setInputState(4);
                    }
                    clientConnState.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener == null) break block8;
                this.eventListener.fatalIOException(iOException, nHttpClientConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(NHttpClientConnection nHttpClientConnection) {
        block13: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState2 = clientConnState;
                synchronized (clientConnState2) {
                    HttpResponse httpResponse = nHttpClientConnection.getHttpResponse();
                    httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                    HttpRequest httpRequest = clientConnState.getRequest();
                    int n = httpResponse.getStatusLine().getStatusCode();
                    if (n < 200) {
                        if (n == 100 && clientConnState.getOutputState() == 2) {
                            clientConnState.setOutputState(1);
                            this.continueRequest(nHttpClientConnection, clientConnState);
                        }
                        return;
                    }
                    clientConnState.setResponse(httpResponse);
                    clientConnState.setInputState(16);
                    if (clientConnState.getOutputState() == 2) {
                        int n2 = clientConnState.getTimeout();
                        nHttpClientConnection.setSocketTimeout(n2);
                        nHttpClientConnection.resetOutput();
                    }
                    if (!this.canResponseHaveBody(httpRequest, httpResponse)) {
                        nHttpClientConnection.resetInput();
                        httpResponse.setEntity(null);
                        clientConnState.setInputState(64);
                        if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
                            nHttpClientConnection.close();
                        }
                    }
                    if (httpResponse.getEntity() != null) {
                        httpResponse.setEntity(new ContentBufferEntity(httpResponse.getEntity(), clientConnState.getInbuffer()));
                    }
                    httpContext.setAttribute("http.response", httpResponse);
                    this.httpProcessor.process(httpResponse, httpContext);
                    this.handleResponse(httpResponse, clientConnState, nHttpClientConnection);
                    clientConnState.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpClientConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpClientConnection, httpException);
                if (this.eventListener == null) break block13;
                this.eventListener.fatalProtocolException(httpException, nHttpClientConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputReady(NHttpClientConnection nHttpClientConnection, ContentDecoder contentDecoder) {
        block8: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState2 = clientConnState;
                synchronized (clientConnState2) {
                    HttpResponse httpResponse = clientConnState.getResponse();
                    ContentInputBuffer contentInputBuffer = clientConnState.getInbuffer();
                    contentInputBuffer.consumeContent(contentDecoder);
                    if (contentDecoder.isCompleted()) {
                        clientConnState.setInputState(64);
                        if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
                            nHttpClientConnection.close();
                        }
                    } else {
                        clientConnState.setInputState(32);
                    }
                    clientConnState.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener == null) break block8;
                this.eventListener.fatalIOException(iOException, nHttpClientConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeout(NHttpClientConnection nHttpClientConnection) {
        block6: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState2 = clientConnState;
                synchronized (clientConnState2) {
                    if (clientConnState.getOutputState() == 2) {
                        clientConnState.setOutputState(1);
                        this.continueRequest(nHttpClientConnection, clientConnState);
                        clientConnState.notifyAll();
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalIOException(iOException, nHttpClientConnection);
            }
        }
        this.handleTimeout(nHttpClientConnection);
    }

    private void initialize(NHttpClientConnection nHttpClientConnection, Object object) {
        HttpContext httpContext = nHttpClientConnection.getContext();
        httpContext.setAttribute("http.connection", nHttpClientConnection);
        this.execHandler.initalizeContext(httpContext, object);
    }

    private void continueRequest(NHttpClientConnection nHttpClientConnection, ClientConnState clientConnState) throws IOException {
        HttpRequest httpRequest = clientConnState.getRequest();
        int n = clientConnState.getTimeout();
        nHttpClientConnection.setSocketTimeout(n);
        this.sendRequestBody((HttpEntityEnclosingRequest)httpRequest, clientConnState, nHttpClientConnection);
    }

    private void sendRequestBody(final HttpEntityEnclosingRequest httpEntityEnclosingRequest, final ClientConnState clientConnState, final NHttpClientConnection nHttpClientConnection) throws IOException {
        HttpEntity httpEntity = httpEntityEnclosingRequest.getEntity();
        if (httpEntity != null) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block13: {
                        try {
                            Object object = clientConnState;
                            synchronized (object) {
                                try {
                                    while (true) {
                                        int n = clientConnState.getOutputState();
                                        if (clientConnState.isWorkerRunning()) {
                                            if (n == -1) {
                                                return;
                                            }
                                            clientConnState.wait();
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    clientConnState.shutdown();
                                    return;
                                }
                                clientConnState.setWorkerRunning(true);
                            }
                            object = new ContentOutputStream(clientConnState.getOutbuffer());
                            httpEntityEnclosingRequest.getEntity().writeTo((OutputStream)object);
                            ((OutputStream)object).flush();
                            ((OutputStream)object).close();
                            ClientConnState clientConnState2 = clientConnState;
                            synchronized (clientConnState2) {
                                clientConnState.setWorkerRunning(false);
                                clientConnState.notifyAll();
                            }
                        }
                        catch (IOException iOException) {
                            ThrottlingHttpClientHandler.this.shutdownConnection(nHttpClientConnection, iOException);
                            if (ThrottlingHttpClientHandler.this.eventListener == null) break block13;
                            ThrottlingHttpClientHandler.this.eventListener.fatalIOException(iOException, nHttpClientConnection);
                        }
                    }
                }
            });
        }
    }

    private void handleResponse(final HttpResponse httpResponse, final ClientConnState clientConnState, final NHttpClientConnection nHttpClientConnection) {
        final HttpContext httpContext = nHttpClientConnection.getContext();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    try {
                        int n;
                        ClientConnState clientConnState2 = clientConnState;
                        synchronized (clientConnState2) {
                            try {
                                while (true) {
                                    n = clientConnState.getOutputState();
                                    if (clientConnState.isWorkerRunning()) {
                                        if (n == -1) {
                                            return;
                                        }
                                        clientConnState.wait();
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                clientConnState.shutdown();
                                return;
                            }
                            clientConnState.setWorkerRunning(true);
                        }
                        ThrottlingHttpClientHandler.this.execHandler.handleResponse(httpResponse, httpContext);
                        clientConnState2 = clientConnState;
                        synchronized (clientConnState2) {
                            try {
                                while ((n = clientConnState.getInputState()) != 64) {
                                    if (n == -1) {
                                        return;
                                    }
                                    clientConnState.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                clientConnState.shutdown();
                            }
                            clientConnState.resetInput();
                            clientConnState.resetOutput();
                            if (nHttpClientConnection.isOpen()) {
                                nHttpClientConnection.requestOutput();
                            }
                            clientConnState.setWorkerRunning(false);
                            clientConnState.notifyAll();
                        }
                    }
                    catch (IOException iOException) {
                        ThrottlingHttpClientHandler.this.shutdownConnection(nHttpClientConnection, iOException);
                        if (ThrottlingHttpClientHandler.this.eventListener == null) break block18;
                        ThrottlingHttpClientHandler.this.eventListener.fatalIOException(iOException, nHttpClientConnection);
                    }
                }
            }
        });
    }

    static class ClientConnState {
        public static final int SHUTDOWN = -1;
        public static final int READY = 0;
        public static final int REQUEST_SENT = 1;
        public static final int EXPECT_CONTINUE = 2;
        public static final int REQUEST_BODY_STREAM = 4;
        public static final int REQUEST_BODY_DONE = 8;
        public static final int RESPONSE_RECEIVED = 16;
        public static final int RESPONSE_BODY_STREAM = 32;
        public static final int RESPONSE_BODY_DONE = 64;
        public static final int RESPONSE_DONE = 64;
        private final SharedInputBuffer inbuffer;
        private final SharedOutputBuffer outbuffer;
        private volatile int inputState;
        private volatile int outputState;
        private volatile HttpRequest request;
        private volatile HttpResponse response;
        private volatile int timeout;
        private volatile boolean workerRunning;

        public ClientConnState(int n, IOControl iOControl, ByteBufferAllocator byteBufferAllocator) {
            this.inbuffer = new SharedInputBuffer(n, iOControl, byteBufferAllocator);
            this.outbuffer = new SharedOutputBuffer(n, iOControl, byteBufferAllocator);
            this.inputState = 0;
            this.outputState = 0;
        }

        public ContentInputBuffer getInbuffer() {
            return this.inbuffer;
        }

        public ContentOutputBuffer getOutbuffer() {
            return this.outbuffer;
        }

        public int getInputState() {
            return this.inputState;
        }

        public void setInputState(int n) {
            this.inputState = n;
        }

        public int getOutputState() {
            return this.outputState;
        }

        public void setOutputState(int n) {
            this.outputState = n;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest httpRequest) {
            this.request = httpRequest;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse httpResponse) {
            this.response = httpResponse;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public boolean isWorkerRunning() {
            return this.workerRunning;
        }

        public void setWorkerRunning(boolean bl) {
            this.workerRunning = bl;
        }

        public void close() {
            this.inbuffer.close();
            this.outbuffer.close();
            this.inputState = -1;
            this.outputState = -1;
        }

        public void shutdown() {
            this.inbuffer.shutdown();
            this.outbuffer.shutdown();
            this.inputState = -1;
            this.outputState = -1;
        }

        public void resetInput() {
            this.inbuffer.reset();
            this.request = null;
            this.inputState = 0;
        }

        public void resetOutput() {
            this.outbuffer.reset();
            this.response = null;
            this.outputState = 0;
        }
    }
}

