/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.MethodNotSupportedException;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.UnsupportedHttpVersionException;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.entity.ByteArrayEntity;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpConnection;
import com.icbc.api.internal.apache.http.nio.NHttpServerConnection;
import com.icbc.api.internal.apache.http.nio.NHttpServiceHandler;
import com.icbc.api.internal.apache.http.nio.entity.ContentBufferEntity;
import com.icbc.api.internal.apache.http.nio.entity.ContentOutputStream;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpHandlerBase;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ContentOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.DirectByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.SharedInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.SharedOutputBuffer;
import com.icbc.api.internal.apache.http.params.DefaultedHttpParams;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpExpectationVerifier;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.protocol.HttpRequestHandlerResolver;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.EncodingUtils;
import com.icbc.api.internal.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ThrottlingHttpServiceHandler
extends NHttpHandlerBase
implements NHttpServiceHandler {
    protected final HttpResponseFactory responseFactory;
    protected final Executor executor;
    protected HttpRequestHandlerResolver handlerResolver;
    protected HttpExpectationVerifier expectationVerifier;
    private final int bufsize;

    public ThrottlingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, ByteBufferAllocator byteBufferAllocator, Executor executor, HttpParams httpParams) {
        super(httpProcessor, connectionReuseStrategy, byteBufferAllocator, httpParams);
        Args.notNull(httpResponseFactory, "Response factory");
        Args.notNull(executor, "Executor");
        this.responseFactory = httpResponseFactory;
        this.executor = executor;
        this.bufsize = this.params.getIntParameter("http.nio.content-buffer-size", 20480);
    }

    public ThrottlingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, Executor executor, HttpParams httpParams) {
        this(httpProcessor, httpResponseFactory, connectionReuseStrategy, DirectByteBufferAllocator.INSTANCE, executor, httpParams);
    }

    public void setHandlerResolver(HttpRequestHandlerResolver httpRequestHandlerResolver) {
        this.handlerResolver = httpRequestHandlerResolver;
    }

    public void setExpectationVerifier(HttpExpectationVerifier httpExpectationVerifier) {
        this.expectationVerifier = httpExpectationVerifier;
    }

    @Override
    public void connected(NHttpServerConnection nHttpServerConnection) {
        HttpContext httpContext = nHttpServerConnection.getContext();
        ServerConnState serverConnState = new ServerConnState(this.bufsize, nHttpServerConnection, this.allocator);
        httpContext.setAttribute("http.nio.conn-state", serverConnState);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen(nHttpServerConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(NHttpServerConnection nHttpServerConnection) {
        HttpContext httpContext = nHttpServerConnection.getContext();
        ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
        if (serverConnState != null) {
            ServerConnState serverConnState2 = serverConnState;
            synchronized (serverConnState2) {
                serverConnState.close();
                serverConnState.notifyAll();
            }
        }
        if (this.eventListener != null) {
            this.eventListener.connectionClosed(nHttpServerConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(NHttpServerConnection nHttpServerConnection, HttpException httpException) {
        block9: {
            if (nHttpServerConnection.isResponseSubmitted()) {
                if (this.eventListener != null) {
                    this.eventListener.fatalProtocolException(httpException, nHttpServerConnection);
                }
                return;
            }
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                HttpResponse httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, httpContext);
                httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                this.handleException(httpException, httpResponse);
                httpResponse.setEntity(null);
                this.httpProcessor.process(httpResponse, httpContext);
                ServerConnState serverConnState2 = serverConnState;
                synchronized (serverConnState2) {
                    serverConnState.setResponse(httpResponse);
                    nHttpServerConnection.requestOutput();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpServerConnection);
                }
            }
            catch (HttpException httpException2) {
                this.closeConnection(nHttpServerConnection, httpException2);
                if (this.eventListener == null) break block9;
                this.eventListener.fatalProtocolException(httpException2, nHttpServerConnection);
            }
        }
    }

    @Override
    public void exception(NHttpServerConnection nHttpServerConnection, IOException iOException) {
        this.shutdownConnection(nHttpServerConnection, iOException);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(iOException, nHttpServerConnection);
        }
    }

    @Override
    public void timeout(NHttpServerConnection nHttpServerConnection) {
        this.handleTimeout(nHttpServerConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestReceived(final NHttpServerConnection nHttpServerConnection) {
        ServerConnState serverConnState;
        HttpContext httpContext = nHttpServerConnection.getContext();
        final HttpRequest httpRequest = nHttpServerConnection.getHttpRequest();
        ServerConnState serverConnState2 = serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
        synchronized (serverConnState2) {
            HttpEntity httpEntity;
            boolean bl = false;
            if (httpRequest instanceof HttpEntityEnclosingRequest && (httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity()) != null) {
                bl = true;
            }
            if (!bl) {
                nHttpServerConnection.suspendInput();
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            ThrottlingHttpServiceHandler.this.handleRequest(httpRequest, serverConnState, nHttpServerConnection);
                        }
                        catch (IOException iOException) {
                            ThrottlingHttpServiceHandler.this.shutdownConnection(nHttpServerConnection, iOException);
                            if (ThrottlingHttpServiceHandler.this.eventListener != null) {
                                ThrottlingHttpServiceHandler.this.eventListener.fatalIOException(iOException, nHttpServerConnection);
                            }
                        }
                        catch (HttpException httpException) {
                            ThrottlingHttpServiceHandler.this.shutdownConnection(nHttpServerConnection, httpException);
                            if (ThrottlingHttpServiceHandler.this.eventListener == null) break block4;
                            ThrottlingHttpServiceHandler.this.eventListener.fatalProtocolException(httpException, nHttpServerConnection);
                        }
                    }
                }
            });
            serverConnState.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputReady(NHttpServerConnection nHttpServerConnection, ContentDecoder contentDecoder) {
        block7: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ServerConnState serverConnState2 = serverConnState;
                synchronized (serverConnState2) {
                    ContentInputBuffer contentInputBuffer = serverConnState.getInbuffer();
                    contentInputBuffer.consumeContent(contentDecoder);
                    if (contentDecoder.isCompleted()) {
                        serverConnState.setInputState(4);
                    } else {
                        serverConnState.setInputState(2);
                    }
                    serverConnState.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener == null) break block7;
                this.eventListener.fatalIOException(iOException, nHttpServerConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReady(NHttpServerConnection nHttpServerConnection) {
        block12: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ServerConnState serverConnState2 = serverConnState;
                synchronized (serverConnState2) {
                    if (serverConnState.isExpectationFailed()) {
                        nHttpServerConnection.resetInput();
                        serverConnState.setExpectationFailed(false);
                    }
                    HttpResponse httpResponse = serverConnState.getResponse();
                    if (serverConnState.getOutputState() == 0 && httpResponse != null && !nHttpServerConnection.isResponseSubmitted()) {
                        nHttpServerConnection.submitResponse(httpResponse);
                        int n = httpResponse.getStatusLine().getStatusCode();
                        HttpEntity httpEntity = httpResponse.getEntity();
                        if (n >= 200 && httpEntity == null) {
                            serverConnState.setOutputState(32);
                            if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
                                nHttpServerConnection.close();
                            }
                        } else {
                            serverConnState.setOutputState(8);
                        }
                    }
                    serverConnState.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpServerConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpServerConnection, httpException);
                if (this.eventListener == null) break block12;
                this.eventListener.fatalProtocolException(httpException, nHttpServerConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outputReady(NHttpServerConnection nHttpServerConnection, ContentEncoder contentEncoder) {
        block8: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                ServerConnState serverConnState2 = serverConnState;
                synchronized (serverConnState2) {
                    HttpResponse httpResponse = serverConnState.getResponse();
                    ContentOutputBuffer contentOutputBuffer = serverConnState.getOutbuffer();
                    contentOutputBuffer.produceContent(contentEncoder);
                    if (contentEncoder.isCompleted()) {
                        serverConnState.setOutputState(32);
                        if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
                            nHttpServerConnection.close();
                        }
                    } else {
                        serverConnState.setOutputState(16);
                    }
                    serverConnState.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener == null) break block8;
                this.eventListener.fatalIOException(iOException, nHttpServerConnection);
            }
        }
    }

    private void handleException(HttpException httpException, HttpResponse httpResponse) {
        if (httpException instanceof MethodNotSupportedException) {
            httpResponse.setStatusCode(501);
        } else if (httpException instanceof UnsupportedHttpVersionException) {
            httpResponse.setStatusCode(505);
        } else if (httpException instanceof ProtocolException) {
            httpResponse.setStatusCode(400);
        } else {
            httpResponse.setStatusCode(500);
        }
        byte[] byArray = EncodingUtils.getAsciiBytes(httpException.getMessage());
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray);
        byteArrayEntity.setContentType("text/plain; charset=US-ASCII");
        httpResponse.setEntity(byteArrayEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpRequest httpRequest, ServerConnState serverConnState, NHttpServerConnection nHttpServerConnection) throws HttpException, IOException {
        Object object;
        Object object2;
        HttpContext httpContext = nHttpServerConnection.getContext();
        Object object3 = serverConnState;
        synchronized (object3) {
            try {
                int n;
                while ((n = serverConnState.getOutputState()) != 0) {
                    if (n == -1) {
                        return;
                    }
                    serverConnState.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                serverConnState.shutdown();
                return;
            }
            serverConnState.setInputState(1);
            serverConnState.setRequest(httpRequest);
        }
        httpRequest.setParams(new DefaultedHttpParams(httpRequest.getParams(), this.params));
        httpContext.setAttribute("http.connection", nHttpServerConnection);
        httpContext.setAttribute("http.request", httpRequest);
        object3 = httpRequest.getRequestLine().getProtocolVersion();
        if (!((ProtocolVersion)object3).lessEquals(HttpVersion.HTTP_1_1)) {
            object3 = HttpVersion.HTTP_1_1;
        }
        HttpResponse httpResponse = null;
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            object2 = (HttpEntityEnclosingRequest)httpRequest;
            if (object2.expectContinue()) {
                httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)object3, 100, httpContext);
                httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                if (this.expectationVerifier != null) {
                    try {
                        this.expectationVerifier.verify(httpRequest, httpResponse, httpContext);
                    }
                    catch (HttpException httpException) {
                        httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, httpContext);
                        httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                        this.handleException(httpException, httpResponse);
                    }
                }
                object = serverConnState;
                synchronized (object) {
                    if (httpResponse.getStatusLine().getStatusCode() < 200) {
                        serverConnState.setResponse(httpResponse);
                        nHttpServerConnection.requestOutput();
                        try {
                            int n;
                            while ((n = serverConnState.getOutputState()) != 8) {
                                if (n == -1) {
                                    return;
                                }
                                serverConnState.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            serverConnState.shutdown();
                            return;
                        }
                        serverConnState.resetOutput();
                        httpResponse = null;
                    } else {
                        object2.setEntity(null);
                        nHttpServerConnection.suspendInput();
                        serverConnState.setExpectationFailed(true);
                    }
                }
            }
            if (object2.getEntity() != null) {
                object2.setEntity(new ContentBufferEntity(object2.getEntity(), serverConnState.getInbuffer()));
            }
        }
        if (httpResponse == null) {
            httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)object3, 200, httpContext);
            httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
            httpContext.setAttribute("http.response", httpResponse);
            try {
                this.httpProcessor.process(httpRequest, httpContext);
                object2 = null;
                if (this.handlerResolver != null) {
                    object = httpRequest.getRequestLine().getUri();
                    object2 = this.handlerResolver.lookup((String)object);
                }
                if (object2 != null) {
                    object2.handle(httpRequest, httpResponse, httpContext);
                } else {
                    httpResponse.setStatusCode(501);
                }
            }
            catch (HttpException httpException) {
                httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, httpContext);
                httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                this.handleException(httpException, httpResponse);
            }
        }
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            object2 = (HttpEntityEnclosingRequest)httpRequest;
            object = object2.getEntity();
            EntityUtils.consume((HttpEntity)object);
        }
        serverConnState.resetInput();
        this.httpProcessor.process(httpResponse, httpContext);
        if (!this.canResponseHaveBody(httpRequest, httpResponse)) {
            httpResponse.setEntity(null);
        }
        serverConnState.setResponse(httpResponse);
        nHttpServerConnection.requestOutput();
        if (httpResponse.getEntity() != null) {
            object2 = serverConnState.getOutbuffer();
            object = new ContentOutputStream((ContentOutputBuffer)object2);
            HttpEntity httpEntity = httpResponse.getEntity();
            httpEntity.writeTo((OutputStream)object);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
        }
        object2 = serverConnState;
        synchronized (object2) {
            try {
                int n;
                while ((n = serverConnState.getOutputState()) != 32) {
                    if (n == -1) {
                        return;
                    }
                    serverConnState.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                serverConnState.shutdown();
                return;
            }
            serverConnState.resetOutput();
            nHttpServerConnection.requestInput();
            serverConnState.notifyAll();
        }
    }

    @Override
    protected void shutdownConnection(NHttpConnection nHttpConnection, Throwable throwable) {
        HttpContext httpContext = nHttpConnection.getContext();
        ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
        super.shutdownConnection(nHttpConnection, throwable);
        if (serverConnState != null) {
            serverConnState.shutdown();
        }
    }

    static class ServerConnState {
        public static final int SHUTDOWN = -1;
        public static final int READY = 0;
        public static final int REQUEST_RECEIVED = 1;
        public static final int REQUEST_BODY_STREAM = 2;
        public static final int REQUEST_BODY_DONE = 4;
        public static final int RESPONSE_SENT = 8;
        public static final int RESPONSE_BODY_STREAM = 16;
        public static final int RESPONSE_BODY_DONE = 32;
        public static final int RESPONSE_DONE = 32;
        private final SharedInputBuffer inbuffer;
        private final SharedOutputBuffer outbuffer;
        private volatile int inputState;
        private volatile int outputState;
        private volatile HttpRequest request;
        private volatile HttpResponse response;
        private volatile boolean expectationFailure;

        public ServerConnState(int n, IOControl iOControl, ByteBufferAllocator byteBufferAllocator) {
            this.inbuffer = new SharedInputBuffer(n, iOControl, byteBufferAllocator);
            this.outbuffer = new SharedOutputBuffer(n, iOControl, byteBufferAllocator);
            this.inputState = 0;
            this.outputState = 0;
        }

        public ContentInputBuffer getInbuffer() {
            return this.inbuffer;
        }

        public ContentOutputBuffer getOutbuffer() {
            return this.outbuffer;
        }

        public int getInputState() {
            return this.inputState;
        }

        public void setInputState(int n) {
            this.inputState = n;
        }

        public int getOutputState() {
            return this.outputState;
        }

        public void setOutputState(int n) {
            this.outputState = n;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest httpRequest) {
            this.request = httpRequest;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse httpResponse) {
            this.response = httpResponse;
        }

        public boolean isExpectationFailed() {
            return this.expectationFailure;
        }

        public void setExpectationFailed(boolean bl) {
            this.expectationFailure = bl;
        }

        public void close() {
            this.inbuffer.close();
            this.outbuffer.close();
            this.inputState = -1;
            this.outputState = -1;
        }

        public void shutdown() {
            this.inbuffer.shutdown();
            this.outbuffer.shutdown();
            this.inputState = -1;
            this.outputState = -1;
        }

        public void resetInput() {
            this.inbuffer.reset();
            this.request = null;
            this.inputState = 0;
        }

        public void resetOutput() {
            this.outbuffer.reset();
            this.response = null;
            this.outputState = 0;
            this.expectationFailure = false;
        }
    }
}

