/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import com.icbc.api.internal.apache.http.protocol.UriPatternMatcher;
import com.icbc.api.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriHttpAsyncRequestHandlerMapper
implements HttpAsyncRequestHandlerMapper {
    private final UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher;

    protected UriHttpAsyncRequestHandlerMapper(UriPatternMatcher<HttpAsyncRequestHandler<?>> uriPatternMatcher) {
        this.matcher = Args.notNull(uriPatternMatcher, "Pattern matcher");
    }

    public UriHttpAsyncRequestHandlerMapper() {
        this(new UriPatternMatcher());
    }

    public void register(String string, HttpAsyncRequestHandler<?> httpAsyncRequestHandler) {
        this.matcher.register(string, httpAsyncRequestHandler);
    }

    public void unregister(String string) {
        this.matcher.unregister(string);
    }

    protected String getRequestPath(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getUri();
        int n = string.indexOf("?");
        if (n != -1) {
            string = string.substring(0, n);
        } else {
            n = string.indexOf("#");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    @Override
    public HttpAsyncRequestHandler<?> lookup(HttpRequest httpRequest) {
        return this.matcher.lookup(this.getRequestPath(httpRequest));
    }
}

