/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.reactor.ssl;

import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBufferManagementStrategy;
import com.icbc.api.internal.apache.http.util.Args;
import java.nio.ByteBuffer;

public class PermanentSSLBufferManagementStrategy
implements SSLBufferManagementStrategy {
    @Override
    public SSLBuffer constructBuffer(int n) {
        return new InternalBuffer(n);
    }

    private static final class InternalBuffer
    implements SSLBuffer {
        private final ByteBuffer buffer;

        public InternalBuffer(int n) {
            Args.positive(n, "size");
            this.buffer = ByteBuffer.allocate(n);
        }

        @Override
        public ByteBuffer acquire() {
            return this.buffer;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isAcquired() {
            return true;
        }

        @Override
        public boolean hasData() {
            return this.buffer.position() > 0;
        }
    }
}

